/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable.goal;

import dev.xylonity.companions.common.entity.ai.antlion.tamable.AbstractAntlionAttackGoal;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.common.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AntlionAdultAttackGoal
extends AbstractAntlionAttackGoal {
    private static final int TOTAL_DURATION = 80;
    private static final int ASCEND_DURATION = 65;
    private static final int DIVE_DURATION = 15;
    private Vec3 hoverPoint;
    private double ascendSpeed;
    private double diveSpeed;
    private double groundLevel;
    private boolean hasStartedDive;

    public AntlionAdultAttackGoal(AntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 80, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.antlion.getVariant() == 2 && this.antlion.getTarget() != null && this.antlion.distanceToSqr((Entity)this.antlion.getTarget()) <= 256.0;
    }

    @Override
    public void start() {
        super.start();
        this.hasStartedDive = false;
        Vec3 targetPos = this.antlion.getTarget() != null ? this.antlion.getTarget().position() : this.antlion.position();
        this.hoverPoint = targetPos.add(0.0, 10.0, 0.0);
        this.ascendSpeed = this.antlion.position().distanceTo(this.hoverPoint) / 65.0;
        this.antlion.setAttackType(1);
    }

    @Override
    public void tick() {
        super.tick();
        LivingEntity target = this.antlion.getTarget();
        if (target == null || !target.isAlive()) {
            this.stop();
            return;
        }
        if (!this.hasStartedDive) {
            Vec3 delta = this.hoverPoint.subtract(this.antlion.position());
            double remaining = delta.length();
            if (remaining <= 0.3) {
                this.startDive();
            } else {
                Vec3 motion = delta.normalize().scale(Math.min(this.ascendSpeed, remaining));
                this.antlion.setDeltaMovement(motion);
                this.antlion.move(MoverType.SELF, motion);
            }
        } else {
            this.antlion.getNavigation().stop();
            this.antlion.setDeltaMovement(0.0, this.diveSpeed, 0.0);
            if (this.antlion.onGround() || this.antlion.getY() <= this.groundLevel) {
                this.stop();
                return;
            }
        }
        if (this.attackTicks >= 80) {
            this.stop();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.antlion.setAttackType(0);
        this.hasStartedDive = false;
        this.performAttack(null);
    }

    private void startDive() {
        this.antlion.cycleState();
        this.groundLevel = this.getGroundLevel();
        this.diveSpeed = -((this.antlion.getY() - this.groundLevel) / 15.0);
        this.hasStartedDive = true;
    }

    private double getGroundLevel() {
        BlockPos.MutableBlockPos pos = this.antlion.blockPosition().mutable();
        int y = pos.getY();
        while (y > this.antlion.level().getMinBuildHeight()) {
            pos.setY(--y);
            if (this.antlion.level().getBlockState((BlockPos)pos).getCollisionShape((BlockGetter)this.antlion.level(), (BlockPos)pos).isEmpty()) continue;
            return y + 1;
        }
        return this.antlion.level().getMinBuildHeight();
    }

    @Override
    protected int attackDelay() {
        return -1;
    }

    @Override
    protected int attackType() {
        return 1;
    }

    @Override
    protected int variant() {
        return 2;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e : this.antlion.level().getEntitiesOfClass(LivingEntity.class, this.antlion.getBoundingBox().inflate(1.0))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.antlion)) continue;
            this.antlion.doHurtTarget((Entity)e);
        }
    }
}

