/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public abstract class AbstractCorneliusAttackGoal
extends Goal {
    protected final CorneliusEntity cornelius;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;
    protected int currentAttackDelay;
    protected int currentAttackDuration;
    protected static final int SPAWN_RADIUS = 3;
    protected static final int MAX_SPAWN_ATTEMPTS = 20;

    public AbstractCorneliusAttackGoal(CorneliusEntity cornelius, int minCd, int maxCd) {
        this.cornelius = cornelius;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.cornelius.isTame()) {
            return false;
        }
        if (!this.cornelius.canAttack()) {
            return false;
        }
        if (this.cornelius.getAttackType() != 0) {
            return false;
        }
        if (this.cornelius.getTarget() == null) {
            return false;
        }
        if (!this.hasSufficientCoins()) {
            this.nextUseTick = -1;
            return false;
        }
        if (this.nextUseTick < 0) {
            int cd = this.minCooldown + this.cornelius.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            this.nextUseTick = this.cornelius.tickCount + cd;
            return false;
        }
        return this.cornelius.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.currentAttackDuration;
    }

    public void start() {
        int currentAttackType = this.cornelius.getRandom().nextInt(3) + 1;
        switch (currentAttackType) {
            case 1: {
                this.currentAttackDelay = 15;
                this.currentAttackDuration = 30;
                break;
            }
            case 2: {
                this.currentAttackDelay = 17;
                this.currentAttackDuration = 25;
                break;
            }
            default: {
                this.currentAttackDelay = 18;
                this.currentAttackDuration = 26;
            }
        }
        this.attackTicks = 0;
        this.started = true;
        this.cornelius.setAttackType(currentAttackType);
        this.cornelius.setSummonedCount(this.cornelius.getSummonedCount() + 1);
        this.consumeCoins();
        this.cornelius.playSound(CompanionsSounds.FROGGY_ATTACK.get());
    }

    public void stop() {
        this.started = false;
        this.cornelius.setAttackType(0);
        this.nextUseTick = -1;
    }

    public void tick() {
        LivingEntity target = this.cornelius.getTarget();
        if (target != null) {
            this.cornelius.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.currentAttackDelay && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected boolean hasSufficientCoins() {
        int found = 0;
        for (int i = 0; i <= 2; ++i) {
            ItemStack stack = this.cornelius.inventory.getItem(i);
            if (stack.getItem() != this.coin() || (found += stack.getCount()) < this.coinsToConsume()) continue;
            return true;
        }
        return false;
    }

    protected void consumeCoins() {
        int toConsume = this.coinsToConsume();
        for (int i = 0; i <= 2 && toConsume > 0; ++i) {
            ItemStack stack = this.cornelius.inventory.getItem(i);
            if (stack.getItem() != this.coin()) continue;
            int remove = Math.min(toConsume, stack.getCount());
            stack.shrink(remove);
            toConsume -= remove;
            this.cornelius.inventory.setItem(i, stack);
        }
    }

    protected boolean isValidSpawnPosition(Level level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        return !level.getBlockState(pos).isSolidRender((BlockGetter)level, pos) && !level.getBlockState(abovePos).isSolidRender((BlockGetter)level, abovePos) && level.getBlockState(pos.below()).isSolidRender((BlockGetter)level, pos.below());
    }

    protected BlockPos findPosAroundCornelius() {
        for (int attempt = 0; attempt < 20; ++attempt) {
            int x = this.cornelius.blockPosition().getX() + this.cornelius.getRandom().nextInt(7) - 3;
            int z = this.cornelius.blockPosition().getZ() + this.cornelius.getRandom().nextInt(7) - 3;
            BlockPos surf = this.findSurfacePosition(this.cornelius.level(), new BlockPos(x, this.cornelius.blockPosition().getY(), z));
            if (surf == null || !this.isValidSpawnPosition(this.cornelius.level(), surf)) continue;
            return surf;
        }
        return this.cornelius.blockPosition();
    }

    protected BlockPos findPosAroundTarget() {
        if (this.cornelius.getTarget() != null) {
            for (int attempt = 0; attempt < 40; ++attempt) {
                int x = this.cornelius.getTarget().blockPosition().getX() + this.cornelius.getTarget().getRandom().nextInt(15) - 7;
                int z = this.cornelius.getTarget().blockPosition().getZ() + this.cornelius.getTarget().getRandom().nextInt(15) - 7;
                BlockPos surf = this.findSurfacePosition(this.cornelius.getTarget().level(), new BlockPos(x, this.cornelius.getTarget().blockPosition().getY(), z));
                if (surf == null || !this.isValidSpawnPosition(this.cornelius.getTarget().level(), surf)) continue;
                return surf;
            }
            return this.cornelius.getTarget().blockPosition();
        }
        return this.cornelius.blockPosition();
    }

    private BlockPos findSurfacePosition(Level level, BlockPos startPos) {
        BlockPos abovePos;
        BlockPos checkPos;
        int y;
        for (y = startPos.getY(); y > level.getMinBuildHeight(); --y) {
            checkPos = new BlockPos(startPos.getX(), y, startPos.getZ());
            abovePos = checkPos.above();
            if (!level.getBlockState(checkPos).isSolidRender((BlockGetter)level, checkPos) || level.getBlockState(abovePos).isSolidRender((BlockGetter)level, abovePos)) continue;
            return abovePos;
        }
        for (y = startPos.getY(); y < level.getMaxBuildHeight(); ++y) {
            checkPos = new BlockPos(startPos.getX(), y, startPos.getZ());
            abovePos = checkPos.above();
            if (!level.getBlockState(checkPos).isSolidRender((BlockGetter)level, checkPos) || level.getBlockState(abovePos).isSolidRender((BlockGetter)level, abovePos)) continue;
            return abovePos;
        }
        return null;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract Item coin();

    protected abstract int coinsToConsume();
}

