/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.SummonFrogEntity;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class SummonHopToTargetGoal<T extends CompanionSummonEntity>
extends Goal {
    private final T summon;
    private final PathNavigation navigation;
    private final double speedModifier;
    private LivingEntity target;
    private int cycleCounter;

    public SummonHopToTargetGoal(T summon, double speedModifier) {
        this.summon = summon;
        this.navigation = summon.getNavigation();
        this.speedModifier = speedModifier;
        this.cycleCounter = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity currentTarget = this.summon.getTarget();
        if (currentTarget == null) {
            return false;
        }
        if (currentTarget.isSpectator()) {
            return false;
        }
        if (((CompanionSummonEntity)((Object)this.summon)).getAttackType() != 0) {
            return false;
        }
        this.target = currentTarget;
        return true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.cycleCounter = 0;
        ((IFrogJumpUtil)this.summon).setCanAttack(false);
    }

    public void stop() {
        this.navigation.stop();
        ((IFrogJumpUtil)this.summon).setCanAttack(true);
        this.target = null;
    }

    public void tick() {
        this.summon.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.summon.getMaxHeadXRot());
        if (((SummonFrogEntity)((Object)this.summon)).getCycleCount() == -1) {
            ((SummonFrogEntity)((Object)this.summon)).setCycleCount(((SummonFrogEntity)((Object)this.summon)).getCycleCount() + 1);
        }
        this.navigation.moveTo((Entity)this.target, this.speedModifier);
        this.cycleCounter = (this.cycleCounter + 1) % 20;
    }
}

