/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractCorneliusSummonAttackGoal
extends Goal {
    protected final CompanionSummonEntity summon;
    protected final int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractCorneliusSummonAttackGoal(CompanionSummonEntity summon, int attackDuration, int minCd, int maxCd) {
        this.summon = summon;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (((Object)((Object)this.summon)).getClass() != this.summonType()) {
            return false;
        }
        if (this.summon.getAttackType() != 0) {
            return false;
        }
        if (this.summon.getTarget() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.summon.tickCount + this.minCooldown + this.summon.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.summon.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.summon.setAttackType(this.getAttackType());
    }

    public void stop() {
        this.started = false;
        this.summon.setAttackType(0);
        int cd = this.minCooldown + this.summon.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.summon.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget = target.getBoundingBox().getCenter().subtract(viewer.getEyePosition(1.0f));
        double distance = toTarget.length();
        if (distance < 1.0E-6) {
            return true;
        }
        Vec3 norm = toTarget.scale(1.0 / distance);
        return viewer.getLookAngle().dot(norm) >= Math.cos(Math.toRadians(fov / 2.0));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract int getAttackType();

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract Class<? extends CompanionSummonEntity> summonType();
}

