/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.projectile.FrogLevitateProjectile;
import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class EnderFrogLevitateGoal
extends AbstractCorneliusSummonAttackGoal {
    public EnderFrogLevitateGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 35, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.summon.getTarget() != null && this.summon.distanceTo((Entity)this.summon.getTarget()) < 15.0f;
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.attackTicks == 24 && this.summon.getTarget() != null && this.summon.getTarget().isAlive()) {
            this.performAttack2(this.summon.getTarget());
        }
    }

    @Override
    protected int getAttackType() {
        return 2;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        FrogLevitateProjectile projectile = (FrogLevitateProjectile)CompanionsEntities.FROG_LEVITATE_PROJECTILE.get().create(this.summon.level());
        if (projectile != null) {
            this.spawnProjectile(projectile, target, 1.2f);
        }
    }

    protected void performAttack2(LivingEntity target) {
        FrogLevitateProjectile projectile = (FrogLevitateProjectile)CompanionsEntities.FROG_LEVITATE_PROJECTILE.get().create(this.summon.level());
        if (projectile != null) {
            this.spawnProjectile(projectile, target, -1.2f);
        }
    }

    private void spawnProjectile(FrogLevitateProjectile projectile, LivingEntity target, float side) {
        Vec3 basePos = this.summon.position().add(0.0, (double)this.summon.getBbHeight() * 0.7, 0.0);
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 dir = targetPos.subtract(basePos).normalize();
        Vec3 perpen = new Vec3(-dir.z, 0.0, dir.x).normalize();
        Vec3 spawnPos = basePos.add(perpen.scale((double)side));
        Vec3 vel = targetPos.subtract(spawnPos).normalize().scale((double)projectile.getDefaultSpeed());
        projectile.setOwner((Entity)this.summon);
        projectile.setTarget(target);
        projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        projectile.setDeltaMovement(vel);
        projectile.setNoGravity(true);
        this.summon.level().addFreshEntity((Entity)projectile);
    }

    @Override
    protected int attackDelay() {
        return 13;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return EnderFrogEntity.class;
    }
}

