/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public abstract class AbstractSoulMageAttackGoal
extends Goal {
    protected final SoulMageEntity soulMage;
    protected int attackTicks;
    protected int nextUseTick;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected boolean started;
    protected final String attackType;

    public AbstractSoulMageAttackGoal(SoulMageEntity soulMage, int minCd, int maxCd, String attackType) {
        this.soulMage = soulMage;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.attackType = attackType;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.soulMage.isAttacking()) {
            return false;
        }
        if (this.soulMage.getTarget() == null) {
            return false;
        }
        if (this.soulMage.tickCount < this.nextUseTick) {
            return false;
        }
        return this.hasRequiredBook();
    }

    public boolean canContinueToUse() {
        return this.attackTicks < 25;
    }

    public void start() {
        this.attackTicks = 0;
        this.soulMage.setAttacking(true);
        TickScheduler.scheduleBoth((Level)this.soulMage.level(), () -> this.soulMage.setAttacking(false), (int)25);
        int rn = new Random().nextInt(3) + 1;
        this.soulMage.setAttackAnimationName(rn == 1 ? "spell" : (rn == 2 ? "spell2" : "spell3"));
        this.soulMage.setCurrentAttackType(this.attackType);
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.soulMage.setCurrentAttackType("NONE");
        int randomCd = this.minCooldown + this.soulMage.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.soulMage.tickCount + randomCd;
    }

    public void tick() {
        if (!this.started) {
            return;
        }
        LivingEntity target = this.soulMage.getTarget();
        if (target != null) {
            this.soulMage.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        ++this.attackTicks;
        if (target != null) {
            this.soulMage.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.shouldPerformAttack(target)) {
            this.performAttack(target);
        }
        if (this.attackTicks >= 25) {
            this.stop();
        }
    }

    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 6 && target != null && target.isAlive();
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract boolean hasRequiredBook();
}

