/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.BigIceShardProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SoulMageIceShardGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageIceShardGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "ICE_SHARD");
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.soulMage.getOwner() != null;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        BigIceShardProjectile projectile;
        if (this.soulMage.getOwner() != null && target != null && (projectile = (BigIceShardProjectile)CompanionsEntities.BIG_ICE_SHARD_PROJECTILE.get().create(this.soulMage.level())) != null) {
            Vec3 up;
            Vec3 forward = this.soulMage.getLookAngle().normalize();
            if (Math.abs(forward.dot(up = new Vec3(0.0, 1.0, 0.0))) > 0.99) {
                up = new Vec3(1.0, 0.0, 0.0);
            }
            Vec3 right = forward.cross(up).normalize();
            double spawnX = this.soulMage.getX() + right.x * 0.5 + up.x * 0.5;
            double spawnY = this.soulMage.getY() + (double)this.soulMage.getBbHeight() + right.y * 0.5 + up.y * 0.5;
            double spawnZ = this.soulMage.getZ() + right.z * 0.5 + up.z * 0.5;
            projectile.moveTo(spawnX, spawnY, spawnZ);
            projectile.setOwner((Entity)this.soulMage);
            double angle = Math.toRadians(30.0);
            double cos = new Random().nextDouble() * (1.0 - Math.cos(angle)) + Math.cos(angle);
            double sin = Math.sqrt(1.0 - cos * cos);
            double phi = new Random().nextDouble() * 2.0 * Math.PI;
            Vec3 dir = new Vec3(sin * Math.cos(phi), cos, sin * Math.sin(phi)).normalize();
            projectile.setDeltaMovement(dir.scale((double)0.2f));
            projectile.setTarget(target);
            this.soulMage.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_ICE_SHARD.get()) continue;
            return true;
        }
        return false;
    }
}

