/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle;

import dev.xylonity.companions.common.entity.ai.minion.tamable.AbstractMinionAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;

public class GargoyleHealAttackGoal
extends AbstractMinionAttackGoal {
    public GargoyleHealAttackGoal(MinionEntity minion, int minCd, int maxCd) {
        super(minion, 20, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.minion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.minion.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        if (!this.minion.getVariant().equals(this.variant())) {
            return false;
        }
        if (this.minion.getAttackType() != 0) {
            return false;
        }
        if (this.minion.getOwner() == null) {
            return false;
        }
        if (this.minion.getMainAction() != 1) {
            return false;
        }
        if (this.minion.getOwner().getHealth() >= this.minion.getOwner().getMaxHealth() * 0.5f) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.minion.tickCount + this.minCooldown + this.minion.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.minion.tickCount >= this.nextUseTick;
    }

    @Override
    public void tick() {
        LivingEntity owner = this.minion.getOwner();
        if (owner != null) {
            this.minion.getLookControl().setLookAt((Entity)owner, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && owner != null && owner.isAlive()) {
            this.performAttack(owner);
        }
        ++this.attackTicks;
    }

    @Override
    protected void performAttack(LivingEntity owner) {
        Projectile healRing;
        if (this.minion.getOwner() != null && (healRing = (Projectile)CompanionsEntities.HEAL_RING_PROJECTILE.get().create(this.minion.getOwner().level())) != null) {
            healRing.moveTo(owner.getX(), owner.getY(), owner.getZ());
            healRing.setOwner((Entity)owner);
            this.minion.getOwner().level().addFreshEntity((Entity)healRing);
        }
    }

    @Override
    protected int attackDelay() {
        return 8;
    }

    @Override
    protected String variant() {
        return MinionEntity.Variant.END.getName();
    }

    @Override
    protected int attackType() {
        return 2;
    }
}

