/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.tamable.imp;

import dev.xylonity.companions.common.entity.ai.minion.tamable.AbstractMinionAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.BraceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ImpBraceAttackGoal
extends AbstractMinionAttackGoal {
    public ImpBraceAttackGoal(MinionEntity minion, int minCd, int maxCd) {
        super(minion, 12, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.minion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.minion.setNoMovement(false);
    }

    @Override
    public void tick() {
        LivingEntity target = this.minion.getTarget();
        if (target != null) {
            this.minion.lookAt((Entity)target, 30.0f, 30.0f);
            float angle = (float)(Math.atan2(target.getZ() - this.minion.getZ(), target.getX() - this.minion.getX()) * 57.29577951308232) - 90.0f;
            this.minion.setYRot(angle);
            this.minion.yBodyRot = angle;
            this.minion.yHeadRot = angle;
            this.minion.yRotO = angle;
            this.minion.yBodyRotO = angle;
            this.minion.yHeadRotO = angle;
        }
        super.tick();
    }

    @Override
    protected void performAttack(LivingEntity target) {
        BraceProjectile projectile;
        if (this.minion.getOwner() != null && (projectile = (BraceProjectile)CompanionsEntities.BRACE_PROJECTILE.get().create(this.minion.level())) != null) {
            Vec3 spawnPos = this.minion.getEyePosition().add(this.minion.getLookAngle().scale(0.6));
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            projectile.setOwner((Entity)this.minion.getOwner());
            Vec3 toPos = target.getEyePosition().subtract(spawnPos).normalize();
            double speed = 1.0;
            Vec3 initialVelocity = toPos.scale(speed).add(this.minion.getOwner().getDeltaMovement());
            projectile.setDeltaMovement(initialVelocity);
            this.minion.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected int attackDelay() {
        return 6;
    }

    @Override
    protected String variant() {
        return MinionEntity.Variant.NETHER.getName();
    }

    @Override
    protected int attackType() {
        return 1;
    }
}

