/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractSacredPontiffAttackGoal
extends Goal {
    protected final SacredPontiffEntity pontiff;
    private final int attackDuration;
    private final int minCooldown;
    private final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractSacredPontiffAttackGoal(SacredPontiffEntity pontiff, int attackDuration, int minCd, int maxCd) {
        this.pontiff = pontiff;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.pontiff.shouldAttack()) {
            return false;
        }
        if (this.pontiff.getState() != this.attackState()) {
            return false;
        }
        if (this.pontiff.getAttackType() != 0) {
            return false;
        }
        if (this.pontiff.getTarget() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.pontiff.tickCount + this.minCooldown + this.pontiff.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.pontiff.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.pontiff.setAttackType(this.getAttackType());
    }

    public void stop() {
        this.started = false;
        this.pontiff.setAttackType(0);
        int cd = this.minCooldown + this.pontiff.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.pontiff.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.pontiff.getTarget();
        if (target != null) {
            this.pontiff.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.getLookAngle().normalize();
        double angle = Math.acos(view.dot(toTarget = new Vec3(target.getX(), viewer.getY(), target.getZ()).subtract(viewer.position()).normalize())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract int getAttackType();

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int attackState();
}

