/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.FireGeiserProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HolinessImpactAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public HolinessImpactAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 64, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
        this.pontiff.setShouldLookAtTarget(false);
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
        this.pontiff.setShouldLookAtTarget(true);
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e2 : target.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.pontiff.blockPosition()).inflate(2.0), e -> !(e instanceof HostileEntity))) {
            this.pontiff.doHurtTarget((Entity)e2);
            e2.knockback(1.0, this.pontiff.getX() - target.getX(), this.pontiff.getZ() - target.getZ());
        }
        Level level = this.pontiff.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.doEarthquake(serverLevel, this.pontiff.blockPosition().relative(this.pontiff.getDirection()));
        }
    }

    private void doEarthquake(ServerLevel serverLevel, BlockPos center) {
        ArrayList<BlockPos> plate;
        int radius = 10;
        boolean[][] claimedPortions = new boolean[radius * 2 + 1][radius * 2 + 1];
        ArrayList plates = new ArrayList();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int cj;
                int ci;
                if ((double)this.pontiff.getRandom().nextFloat() > 0.2 || claimedPortions[ci = dx + radius][cj = dz + radius]) continue;
                int size = 3 + this.pontiff.getRandom().nextInt(2);
                plate = new ArrayList<BlockPos>(size * size);
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        int jj;
                        int ii;
                        int rx = dx + x;
                        int rz = dz + z;
                        if (Math.abs(rx) > radius || Math.abs(rz) > radius || claimedPortions[ii = rx + radius][jj = rz + radius]) continue;
                        claimedPortions[ii][jj] = true;
                        plate.add(center.offset(rx, -1, rz));
                    }
                }
                if (plate.isEmpty()) continue;
                plates.add(plate);
            }
        }
        int tickDelay = 0;
        int plateCount = 0;
        for (int i = 0; i < plates.size(); ++i) {
            if (plateCount == 4) {
                tickDelay += 3;
                plateCount = 0;
            }
            double yDelay = 0.18 + 0.005 * (double)i;
            plate = (ArrayList<BlockPos>)plates.get(i);
            Runnable task = () -> {
                for (BlockPos bp : plate) {
                    BlockState state = serverLevel.getBlockState(bp);
                    if (state.isAir() || state.getBlock() == Blocks.BEDROCK) continue;
                    this.spawnFallingBlock(serverLevel, bp, state, yDelay);
                }
                BlockPos randPos = (BlockPos)plate.get(this.pontiff.getRandom().nextInt(plate.size()));
                double x = (double)randPos.getX() + this.pontiff.getRandom().nextDouble();
                double z = (double)randPos.getZ() + this.pontiff.getRandom().nextDouble();
                FireGeiserProjectile geiser = (FireGeiserProjectile)CompanionsEntities.FIRE_GEISER_PROJECTILE.get().create((Level)serverLevel);
                if (geiser != null && serverLevel.random.nextFloat() < 0.35f) {
                    geiser.moveTo(x, (double)randPos.getY() + 0.75, z, 0.0f, 0.0f);
                    geiser.setOwner((Entity)this.pontiff);
                    serverLevel.addFreshEntity((Entity)geiser);
                }
                if (this.pontiff.getRandom().nextFloat() < 0.65f) {
                    for (int j = 0; j < 10; ++j) {
                        double dx = (this.pontiff.getRandom().nextDouble() - 0.5) * 2.0;
                        double dy = (this.pontiff.getRandom().nextDouble() - 0.5) * 2.0;
                        double dz = (this.pontiff.getRandom().nextDouble() - 0.5) * 2.0;
                        Level patt0$temp = this.pontiff.level();
                        if (!(patt0$temp instanceof ServerLevel)) continue;
                        ServerLevel level = (ServerLevel)patt0$temp;
                        level.sendParticles((ParticleOptions)ParticleTypes.POOF, x, (double)(randPos.getY() + 1), z, 1, dx, dy, dz, 0.2);
                    }
                }
            };
            if (tickDelay == 0) {
                task.run();
            } else {
                TickScheduler.scheduleServer((Level)serverLevel, (Runnable)task, (int)tickDelay);
            }
            ++plateCount;
        }
    }

    private void spawnFallingBlock(ServerLevel level, BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity fallingBlock = new FallingBlockEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, state);
        fallingBlock.setDeltaMovement(0.0, yDelay, 0.0);
        level.addFreshEntity((Entity)fallingBlock);
        level.removeBlock(pos, false);
    }

    @Override
    protected int attackDelay() {
        return 35;
    }

    @Override
    protected int attackState() {
        return 6;
    }
}

