/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class HolinessMeleeAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public HolinessMeleeAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 25, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
        this.pontiff.playSound(CompanionsSounds.HOLINESS_STAB.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.pontiff.getTarget() != null && this.pontiff.distanceTo((Entity)this.pontiff.getTarget()) < 4.0f && HolinessMeleeAttackGoal.isEntityInFront((LivingEntity)this.pontiff, (Entity)this.pontiff.getTarget(), 200.0);
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (Entity e2 : target.level().getEntitiesOfClass(Entity.class, new AABB(new BlockPos((int)target.getX(), (int)target.getY(), (int)target.getZ())).inflate(3.0), e -> !(e instanceof HostileEntity))) {
            LivingEntity livingEntity;
            if (!(e2 instanceof LivingEntity) || !this.pontiff.hasLineOfSight((Entity)(livingEntity = (LivingEntity)e2)) || !HolinessMeleeAttackGoal.isEntityInFront((LivingEntity)this.pontiff, (Entity)livingEntity, 180.0)) continue;
            this.pontiff.doHurtTarget((Entity)livingEntity);
            livingEntity.knockback(0.5, this.pontiff.getX() - target.getX(), this.pontiff.getZ() - target.getZ());
        }
    }

    @Override
    protected int attackDelay() {
        return 10;
    }

    @Override
    protected int attackState() {
        return 6;
    }
}

