/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.PontiffFireRingProjectile;
import dev.xylonity.companions.common.entity.projectile.trigger.FireRayBeamEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PontiffRotatingFireRayGoal
extends AbstractSacredPontiffAttackGoal {
    public PontiffRotatingFireRayGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 171, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
    }

    @Override
    public void tick() {
        PontiffFireRingProjectile ring;
        super.tick();
        if (this.attackTicks >= 21 && this.attackTicks <= 150 && this.attackTicks % 20 == 0 && (ring = (PontiffFireRingProjectile)CompanionsEntities.PONTIFF_FIRE_RING.get().create(this.pontiff.level())) != null) {
            ring.setOwner((Entity)this.pontiff);
            ring.moveTo(this.pontiff.getX(), this.pontiff.getY(), this.pontiff.getZ());
            this.pontiff.level().addFreshEntity((Entity)ring);
        }
    }

    private void doAttack() {
        Level level = this.pontiff.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel s = (ServerLevel)level;
        Vec3 origin = this.pontiff.position().add(0.0, (double)this.pontiff.getBbHeight() + 3.5, 0.0);
        float yaw = this.pontiff.getRandom().nextFloat() * 360.0f;
        float pitch = -this.pontiff.getRandom().nextFloat() * 60.0f;
        FireRayBeamEntity beam = new FireRayBeamEntity(s, origin, yaw, pitch, 150, 30, 1.0f, this.pontiff);
        s.addFreshEntity((Entity)beam);
    }

    @Override
    protected int getAttackType() {
        return 3;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (int i = 0; i < 10; ++i) {
            TickScheduler.scheduleServer((Level)this.pontiff.level(), this::doAttack, (int)new Random().nextInt(0, 10));
        }
    }

    @Override
    protected int attackDelay() {
        return 10;
    }

    @Override
    protected int attackState() {
        return 2;
    }
}

