/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.PontiffFireRingProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PontiffStaffKnockAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public PontiffStaffKnockAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 31, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
        this.pontiff.playSound(CompanionsSounds.PONTIFF_FRONT_ATTACK.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 lookVec = this.pontiff.getLookAngle().normalize();
        Vec3 forwardXZ = new Vec3(lookVec.x, 0.0, lookVec.z).normalize();
        if (forwardXZ.lengthSqr() == 0.0) {
            forwardXZ = new Vec3(0.0, 0.0, 1.5);
        }
        Vec3 spawnPos = this.pontiff.position().add(forwardXZ).add(new Vec3(forwardXZ.z, 0.0, -forwardXZ.x));
        PontiffFireRingProjectile ring = (PontiffFireRingProjectile)CompanionsEntities.PONTIFF_FIRE_RING.get().create(this.pontiff.level());
        if (ring != null) {
            ring.setOwner((Entity)this.pontiff);
            ring.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, this.pontiff.getYRot(), this.pontiff.getXRot());
            this.pontiff.level().addFreshEntity((Entity)ring);
            Level level = this.pontiff.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                RandomSource random = level2.getRandom();
                for (int i = 0; i < 7; ++i) {
                    double velX = (double)random.nextFloat() / 2.0;
                    double velY = 5.0E-5;
                    double velZ = (double)random.nextFloat() / 2.0;
                    level2.sendParticles((ParticleOptions)ParticleTypes.LAVA, spawnPos.x, spawnPos.y + 0.05, spawnPos.z, 1, velX, velY, velZ, 0.0);
                }
                level2.sendParticles((ParticleOptions)ParticleTypes.CLOUD, spawnPos.x, spawnPos.y + 0.1, spawnPos.z, 6, 0.1, 0.1, 0.1, 0.1);
                level2.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, spawnPos.x, spawnPos.y + 0.1, spawnPos.z, 2, 0.01, 0.01, 0.01, 0.05);
            }
        }
        this.pontiff.playSound(CompanionsSounds.HOLINESS_STAB.get());
    }

    @Override
    protected int attackDelay() {
        return 29;
    }

    @Override
    protected int attackState() {
        return 2;
    }
}

