/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet;

import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractPuppetLeftAttackGoal
extends Goal {
    protected final PuppetEntity puppet;
    protected int attackTicks;
    protected int nextUseTick;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected boolean started;
    protected final String attackType;

    public AbstractPuppetLeftAttackGoal(PuppetEntity puppet, int minCd, int maxCd, String attackType) {
        this.puppet = puppet;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.attackType = attackType;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.puppet.isAttackingLeft()) {
            return false;
        }
        if (this.puppet.getTarget() == null) {
            return false;
        }
        if (this.puppet.tickCount < this.nextUseTick) {
            return false;
        }
        return this.hasRequiredArm();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.attackTicks < 13;
    }

    public void start() {
        this.attackTicks = 0;
        this.puppet.setAttackingLeft(true);
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.puppet.setAttackingLeft(false);
        int randomCd = this.minCooldown + this.puppet.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.puppet.tickCount + randomCd;
    }

    public void tick() {
        if (!this.started) {
            return;
        }
        LivingEntity target = this.puppet.getTarget();
        if (target != null) {
            this.puppet.getLookControl().setLookAt((Entity)target, 90.0f, 90.0f);
        }
        ++this.attackTicks;
        if (target != null) {
            this.puppet.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.shouldPerformAttack(target)) {
            this.performAttack(target);
        }
        if (this.attackTicks >= 13) {
            this.stop();
        }
    }

    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 3 && target != null && target.isAlive();
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract boolean hasRequiredArm();
}

