/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet.goal;

import dev.xylonity.companions.common.entity.ai.puppet.AbstractPuppetRightAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PuppetRightMutantAttackGoal
extends AbstractPuppetRightAttackGoal {
    public PuppetRightMutantAttackGoal(PuppetEntity puppet, int minCd, int maxCd) {
        super(puppet, minCd, maxCd, "BLADE");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null) {
            this.puppet.doHurtTarget((Entity)target);
            target.addEffect(new MobEffectInstance(CompanionsEffects.VOODOO, this.puppet.getRandom().nextInt(100, 300), 0, true, true, true));
        }
    }

    @Override
    public void start() {
        super.start();
        this.puppet.playSound(CompanionsSounds.PUPPET_ATTACK_MUTANT.get());
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.puppet.getTarget() != null && this.puppet.distanceToSqr((Entity)this.puppet.getTarget()) <= 4.0;
    }

    @Override
    protected boolean hasRequiredArm() {
        return this.puppet.inventory.getItem(0).is(CompanionsItems.MUTANT_ARM.get());
    }
}

