/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade;

import dev.xylonity.companions.common.entity.ShadeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractShadeAttackGoal
extends Goal {
    protected final ShadeEntity shade;
    protected final int attackDuration;
    private final int minCooldown;
    private final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractShadeAttackGoal(ShadeEntity shade, int attackDuration, int minCd, int maxCd) {
        this.shade = shade;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.shade.isSpawning()) {
            return false;
        }
        if (((Object)((Object)this.shade)).getClass() != this.shadeType()) {
            return false;
        }
        if (this.shade.getAttackType() != 0) {
            return false;
        }
        if (this.shade.getTarget() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.shade.tickCount + this.minCooldown + this.shade.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.shade.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.shade.setAttackType(this.getAttackType());
    }

    public void stop() {
        this.started = false;
        this.shade.setAttackType(0);
        int cd = this.minCooldown + this.shade.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.shade.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.shade.getTarget();
        if (target != null) {
            this.shade.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget = target.getBoundingBox().getCenter().subtract(viewer.getEyePosition(1.0f));
        double distance = toTarget.length();
        if (distance < 1.0E-6) {
            return true;
        }
        Vec3 norm = toTarget.scale(1.0 / distance);
        return viewer.getLookAngle().dot(norm) >= Math.cos(Math.toRadians(fov / 2.0));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract int getAttackType();

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract Class<? extends ShadeEntity> shadeType();
}

