/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.ai.teddy.AbstractTeddyAttackGoal;
import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MutatedTeddyAttackGoal
extends AbstractTeddyAttackGoal {
    public MutatedTeddyAttackGoal(TeddyEntity teddy, int minCd, int maxCd) {
        super(teddy, 20, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.teddy.getTarget() != null && this.teddy.distanceToSqr((Entity)this.teddy.getTarget()) < 4.0 && this.teddy.getPhase() == 2;
    }

    @Override
    public void start() {
        int curr = this.teddy.getRandom().nextInt(2) + 1;
        this.attackDuration = curr == 1 ? 20 : 15;
        this.attackTicks = 0;
        this.started = true;
        this.teddy.setAttackType(curr);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (this.teddy.hasLineOfSight((Entity)target)) {
            this.teddy.playSound(CompanionsSounds.MUTANT_TEDDY_ATTACK.get());
            this.teddy.doHurtTarget((Entity)target);
        }
    }

    @Override
    protected int attackDelay() {
        return 7;
    }

    @Override
    protected int phase() {
        return 2;
    }

    @Override
    protected int getAttackType() {
        return 1;
    }
}

