/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class MutatedTeddyFollowTargetGoal
extends Goal {
    private static final double RADIUS_VARIATION = 2.5;
    private static final double Y_AMPL = 0.8;
    private static final double Y_OSCILATION = 0.25;
    private static final int MIN_DIR_TIME = 40;
    private static final int MAX_DIR_TIME = 160;
    private static final int MIN_IDLE_TIME = 5;
    private static final int MAX_IDLE_TIME = 10;
    private static final int CHARGE_COOLDOWN = 80;
    private final TeddyEntity teddy;
    private LivingEntity target;
    private double angle;
    private double time;
    private int dir;
    private State state;
    private int ticksInState;
    private int untilNextDirChange;
    private int untilNextCharge;
    private Vec3 chargeDir = Vec3.ZERO;

    public MutatedTeddyFollowTargetGoal(TeddyEntity teddy) {
        this.teddy = teddy;
        this.dir = teddy.getRandom().nextBoolean() ? 1 : -1;
        this.untilNextDirChange = teddy.getRandom().nextInt(120) + 40;
        this.untilNextCharge = 80;
        this.state = State.ORBIT;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.teddy.getPhase() == 1) {
            return false;
        }
        if (this.teddy.getTarget() == null) {
            return false;
        }
        this.target = this.teddy.getTarget();
        return this.target.isAlive();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        this.teddy.lookAt((Entity)this.target, 30.0f, 30.0f);
        ++this.ticksInState;
        this.time += 0.04;
        switch (this.state.ordinal()) {
            case 0: {
                this.orbitTick();
                break;
            }
            case 1: {
                this.idleTick();
                break;
            }
            case 2: {
                this.chargeTick();
            }
        }
    }

    private void orbitTick() {
        Vec3 center = new Vec3(this.target.getX(), this.target.getY() + (double)this.target.getBbHeight() * 0.5, this.target.getZ());
        Vec3 relativePos = this.teddy.position().subtract(center);
        double currAngle = Math.atan2(relativePos.z, relativePos.x);
        if (currAngle < 0.0) {
            currAngle += Math.PI * 2;
        }
        if (this.teddy.getTeleported()) {
            this.angle = currAngle;
            this.teddy.setTeleported(false);
        } else if (Math.abs(currAngle - this.angle) > Math.PI) {
            this.angle = currAngle;
        }
        this.angle = (this.angle + 0.03225 * (double)this.dir) % (Math.PI * 2);
        double r = 4.0 + 1.25 * (1.0 + Math.sin(this.time * 0.35 * Math.PI * 2.0));
        double y = 0.8 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        Vec3 nextPos = this.teddy.position().lerp(center.add(r * Math.cos(this.angle), y + 0.7, r * Math.sin(this.angle)), 0.12);
        this.teddy.setPos(nextPos.x, nextPos.y, nextPos.z);
        this.teddy.setDeltaMovement(Vec3.ZERO);
        if (this.ticksInState >= this.untilNextDirChange) {
            if (this.untilNextCharge <= 0) {
                this.state = State.CHARGE;
                this.chargeDir = center.subtract(this.teddy.position()).normalize();
                this.ticksInState = 0;
            } else {
                if (this.teddy.getRandom().nextBoolean()) {
                    this.dir *= -1;
                } else {
                    this.state = State.IDLE;
                }
                this.ticksInState = 0;
                this.untilNextDirChange = this.teddy.getRandom().nextInt(120) + 40;
            }
        }
        --this.untilNextCharge;
    }

    private void idleTick() {
        double y = 0.4 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        this.teddy.setPos(this.teddy.getX(), this.teddy.getY() + y * 0.1, this.teddy.getZ());
        this.teddy.setDeltaMovement(Vec3.ZERO);
        if (this.ticksInState >= this.teddy.getRandom().nextInt(5) + 5) {
            this.state = State.ORBIT;
            this.ticksInState = 0;
        }
    }

    private void chargeTick() {
        Vec3 v = this.chargeDir.scale(0.2875);
        this.teddy.setDeltaMovement(v);
        this.teddy.moveTo(this.target.position().add(v));
        this.teddy.setTeleported(true);
        if (this.ticksInState > 12 || this.teddy.distanceToSqr((Entity)this.target) < 4.0) {
            this.teddy.setDeltaMovement(Vec3.ZERO);
            this.state = State.ORBIT;
            this.ticksInState = 0;
            this.teddy.setTeleported(false);
            this.untilNextCharge = 80;
        }
    }

    public void stop() {
        this.teddy.setDeltaMovement(Vec3.ZERO);
        super.stop();
    }

    private static enum State {
        ORBIT,
        IDLE,
        CHARGE;

    }
}

