/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.ai.teddy.AbstractTeddyAttackGoal;
import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import dev.xylonity.companions.common.entity.projectile.NeedleProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeddyVoodooAttackGoal
extends AbstractTeddyAttackGoal {
    private List<LivingEntity> list = new ArrayList<LivingEntity>();

    public TeddyVoodooAttackGoal(TeddyEntity teddy, int minCd, int maxCd) {
        super(teddy, 21, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        this.list = this.teddy.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.teddy.blockPosition()).inflate(20.0), e -> e.hasEffect(CompanionsEffects.VOODOO) && !Util.areEntitiesLinked((Entity)e, (Entity)this.teddy));
        if (this.list.isEmpty()) {
            return false;
        }
        if (this.teddy.getPhase() == 2) {
            return false;
        }
        if (this.phase() != this.teddy.getPhase()) {
            return false;
        }
        if (this.teddy.getAttackType() != 0) {
            return false;
        }
        if (this.teddy.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.teddy.tickCount + this.minCooldown + this.teddy.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.teddy.tickCount >= this.nextUseTick;
    }

    @Override
    public void start() {
        super.start();
        this.teddy.setNoMovement(true);
        this.teddy.playSound(CompanionsSounds.TEDDY_AUTO_STAB.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.list.clear();
        this.teddy.setNoMovement(false);
    }

    @Override
    public void tick() {
        LivingEntity target = this.teddy.getTarget();
        if (target != null) {
            this.teddy.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == 16) {
            this.performAttack(target);
        }
        if (this.attackTicks == this.attackDelay()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    @Override
    protected void performAttack(LivingEntity unused) {
        for (LivingEntity e : this.list) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.teddy)) continue;
            e.removeEffect(CompanionsEffects.VOODOO);
            for (int i = 0; i < 2; ++i) {
                double radius = 4.0 + this.teddy.getRandom().nextDouble();
                double angle = this.teddy.getRandom().nextDouble() * Math.PI * 2.0;
                double x = e.getX() + Math.cos(angle) * radius;
                double y = e.getBoundingBox().minY + (double)e.getBbHeight() * 0.75 + this.teddy.getRandom().nextDouble() * (double)e.getBbHeight() * 0.5 + 1.0;
                double z = e.getZ() + Math.sin(angle) * radius;
                NeedleProjectile needle = (NeedleProjectile)CompanionsEntities.NEEDLE_PROJECTILE.get().create(this.teddy.level());
                if (needle == null) continue;
                needle.setOwner((Entity)this.teddy);
                needle.moveTo(new Vec3(x, y, z));
                needle.setDeltaMovement(e.position().add(new Vec3(0.0, (double)e.getBbHeight() * 0.65, 0.0)).subtract(new Vec3(x, y, z)).normalize().scale(1.25));
                needle.refreshOrientation();
                needle.setInvisible(true);
                this.teddy.level().addFreshEntity((Entity)needle);
            }
        }
    }

    @Override
    protected int attackDelay() {
        return 7;
    }

    @Override
    protected int phase() {
        return 1;
    }

    @Override
    protected int getAttackType() {
        return 2;
    }
}

