/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.croissant.CroissantDragonAttackGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class CroissantDragonEntity
extends CompanionEntity {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation EATEN = RawAnimation.begin().thenPlay("eaten");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> ARMOR_NAME = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> EATEN_AMOUNT = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_BEEN_EATEN = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> MILK_AMOUNT = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> VIEW_VEC_X = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> VIEW_VEC_Y = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> VIEW_VEC_Z = SynchedEntityData.defineId(CroissantDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final int EATEN_DELAY = 10;
    private int nextEatenRecover = 0;

    public CroissantDragonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new CroissantDragonAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAttacking()) {
            Companions.PROXY.updateCreamParticle(this.getStoredViewVector());
        }
        if (!this.level().isClientSide) {
            if (this.getEatenAmount() > 0 && this.tickCount >= this.nextEatenRecover) {
                this.setEatenAmount(this.getEatenAmount() - 1);
                this.setHasBeenEaten(true);
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setHasBeenEaten(false), (int)10);
                this.nextEatenRecover = this.tickCount + this.level().getRandom().nextInt(201) + 100;
            }
            if (this.isTame()) {
                this.setMilkAmount(3);
            }
        }
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.CROISSANT_DRAGON_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void setEatenAmount(int eatenAmount) {
        this.entityData.set(EATEN_AMOUNT, (Object)eatenAmount);
    }

    public int getEatenAmount() {
        return (Integer)this.entityData.get(EATEN_AMOUNT);
    }

    public void setArmorName(String name) {
        this.entityData.set(ARMOR_NAME, (Object)name);
    }

    public String getArmorName() {
        return (String)this.entityData.get(ARMOR_NAME);
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.getEatenAmount() > 0) {
            this.playSound(CompanionsSounds.CROISSANT_DRAGON_CREAM_STEPS.get());
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.CROISSANT_DRAGON_CREAM_DEATH.get();
    }

    public void playAmbientSound() {
        this.playSound(CompanionsSounds.CROISSANT_DRAGON_CREAM_IDLE.get(), 0.4f, 1.0f);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.CROISSANT_DRAGON_CREAM_HURT.get();
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    public boolean hasBeenEaten() {
        return (Boolean)this.entityData.get(HAS_BEEN_EATEN);
    }

    public void setHasBeenEaten(boolean eaten) {
        this.entityData.set(HAS_BEEN_EATEN, (Object)eaten);
    }

    public int getMilkAmount() {
        return (Integer)this.entityData.get(MILK_AMOUNT);
    }

    public void setMilkAmount(int milk) {
        this.entityData.set(MILK_AMOUNT, (Object)milk);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(ARMOR_NAME, (Object)"default");
        builder.define(EATEN_AMOUNT, (Object)0);
        builder.define(HAS_BEEN_EATEN, (Object)false);
        builder.define(MILK_AMOUNT, (Object)0);
        builder.define(VIEW_VEC_X, (Object)Float.valueOf(0.0f));
        builder.define(VIEW_VEC_Y, (Object)Float.valueOf(0.0f));
        builder.define(VIEW_VEC_Z, (Object)Float.valueOf(0.0f));
    }

    public void setStoredViewVector(Vec3 vec) {
        this.entityData.set(VIEW_VEC_X, (Object)Float.valueOf((float)vec.x));
        this.entityData.set(VIEW_VEC_Y, (Object)Float.valueOf((float)vec.y));
        this.entityData.set(VIEW_VEC_Z, (Object)Float.valueOf((float)vec.z));
    }

    public Vec3 getStoredViewVector() {
        return new Vec3((double)((Float)this.entityData.get(VIEW_VEC_X)).floatValue(), (double)((Float)this.entityData.get(VIEW_VEC_Y)).floatValue(), (double)((Float)this.entityData.get(VIEW_VEC_Z)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("MilkAmount")) {
            this.setMilkAmount(pCompound.getInt("MilkAmount"));
        }
        if (pCompound.contains("EatenAmount")) {
            this.setEatenAmount(pCompound.getInt("EatenAmount"));
        }
        if (pCompound.contains("ArmorName")) {
            this.setArmorName(pCompound.getString("ArmorName"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("MilkAmount", this.getMilkAmount());
        pCompound.putInt("EatenAmount", this.getEatenAmount());
        pCompound.putString("ArmorName", this.getArmorName());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.CROISSANT_DRAGON_KEEP_CHUNK_LOADED;
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isTame() && this.getOwner() == player && player.isShiftKeyDown() && !this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.getEatenAmount() < 2 && !this.hasBeenEaten()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            this.playSound(SoundEvents.WOOL_BREAK, 0.5f, 1.0f);
            this.setEatenAmount(this.getEatenAmount() + 1);
            this.setHasBeenEaten(true);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setHasBeenEaten(false), (int)10);
            this.nextEatenRecover = this.tickCount + this.level().getRandom().nextInt(201) + 100;
            switch (this.getArmorName()) {
                case "chocolate": {
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 200, 0));
                    break;
                }
                case "strawberry": {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 180, 1));
                    break;
                }
                case "vanilla": {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0));
                    break;
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isTame() && itemstack.getItem() == Items.MILK_BUCKET && this.getMilkAmount() < 3) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                if (itemstack.isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BUCKET));
                } else if (!player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET))) {
                    player.drop(new ItemStack((ItemLike)Items.BUCKET), false);
                }
            }
            if (this.getMilkAmount() == 2 && !this.level().isClientSide) {
                this.tameInteraction(player);
            }
            this.setMilkAmount(this.getMilkAmount() + 1);
            player.level().playSound(null, this.blockPosition(), SoundEvents.HONEY_DRINK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!this.isTame()) {
            player.displayClientMessage((Component)Component.translatable((String)"croissant_dragon.companions.client_message.requires_milk"), true);
            player.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        if (this.isTame() && !this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.getOwner() == player && this.getArmorName().equals("default")) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == CompanionsItems.CROISSANT_DRAGON_ARMOR_STRAWBERRY.get()) {
                this.setArmorName("strawberry");
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == CompanionsItems.CROISSANT_DRAGON_ARMOR_VANILLA.get()) {
                this.setArmorName("vanilla");
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == CompanionsItems.CROISSANT_DRAGON_ARMOR_CHOCOLATE.get()) {
                this.setArmorName("chocolate");
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            this.playSound(SoundEvents.WOOL_BREAK, 0.5f, 1.0f);
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "eatencontroller", 2, this::eatenPredicate));
    }

    private <T extends GeoAnimatable> PlayState eatenPredicate(AnimationState<T> event) {
        if (this.hasBeenEaten() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.EATEN);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
        } else if (this.isAttacking()) {
            event.getController().setAnimation(this.ATTACK);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.getEatenAmount() == 0 ? this.FLY : this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void aiStep() {
        this.setNoMovement(this.isAttacking());
        super.aiStep();
    }
}

