/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoAttackBehaviour;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DinamoEntity
extends CompanionEntity
implements GeoEntity {
    private final TeslaConnectionManager connectionManager;
    public List<LivingEntity> entitiesToAttack = new ArrayList<LivingEntity>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CYCLE_COUNTER = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIMATION_START_TICK = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ATTACK_ACTIVE = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_CYCLE_COUNTER = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> TARGET_IDS = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> SHOULD_ATTACK = SynchedEntityData.defineId(DinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ITeslaGeneratorBehaviour pulseBehavior;
    private final ITeslaGeneratorBehaviour attackBehavior;

    public DinamoEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.connectionManager = TeslaConnectionManager.getInstance();
        this.pulseBehavior = new DinamoPulseBehaviour();
        this.attackBehavior = new DinamoAttackBehaviour();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(2, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this){

            @Override
            public void start() {
                super.start();
                DinamoEntity.this.setTargetIds(DinamoEntity.this.getTargetIds() + this.getOwnerLastHurt().getId() + ";");
            }
        });
    }

    public TeslaConnectionManager.ConnectionNode asConnectionNode() {
        return TeslaConnectionManager.ConnectionNode.forEntity(this.getUUID(), this.level().dimension().location());
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ListTag outgoing = new ListTag();
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(this.asConnectionNode())) {
            outgoing.add((Object)node.serialize());
        }
        tag.put("OutgoingConnections", (Tag)outgoing);
        tag.putInt("AnimationStartTick", this.getAnimationStartTick());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.DINAMO_KEEP_CHUNK_LOADED;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        TeslaConnectionManager.ConnectionNode me = this.asConnectionNode();
        this.connectionManager.getOutgoing(me).clear();
        this.connectionManager.getIncoming(me).clear();
        if (tag.contains("OutgoingConnections")) {
            ListTag outgoingList = tag.getList("OutgoingConnections", 10);
            for (Tag t : outgoingList) {
                TeslaConnectionManager.ConnectionNode node = TeslaConnectionManager.ConnectionNode.deserialize((CompoundTag)t);
                this.connectionManager.addConnection(me, node, true);
            }
        }
        this.connectionManager.recalculateDistances();
    }

    public void die(@NotNull DamageSource pCause) {
        super.die(pCause);
        HashSet<TeslaConnectionManager.ConnectionNode> outNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getOutgoing(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode target : outNodes) {
            this.connectionManager.removeConnection(this.asConnectionNode(), target);
        }
        HashSet<TeslaConnectionManager.ConnectionNode> inNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getIncoming(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode source : inNodes) {
            this.connectionManager.removeConnection(source, this.asConnectionNode());
        }
        this.connectionManager.removeConnectionNode(this.asConnectionNode());
        this.connectionManager.recalculateDistances();
    }

    public static AttributeSupplier setAttributes() {
        return Raider.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.DINAMO_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isTame() && !this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.getOwner() == player && player.getMainHandItem().getItem() != CompanionsItems.WRENCH.get()) {
            if (player.isShiftKeyDown() && this.getMainAction() != 0) {
                this.setShouldAttack(!this.shouldAttack());
                if (this.shouldAttack()) {
                    player.displayClientMessage((Component)Component.translatable((String)"dinamo.companions.client_message.attack").withStyle(ChatFormatting.GREEN), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"dinamo.companions.client_message.no_attack").withStyle(ChatFormatting.GREEN), true);
                }
            } else {
                if (this.level().isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.handleDefaultMainActionAndHeal(player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isAlive()) {
            this.setActive(false);
        }
        if (this.level().isClientSide && this.getAttackCycleCounter() >= 60) {
            this.entitiesToAttack.clear();
        }
        if (this.getMainAction() == 0) {
            this.pulseBehavior.tick(this);
        } else {
            this.attackBehavior.tick(this);
        }
        if (this.level().isClientSide && !this.getTargetIds().isEmpty() && !this.getTargetIds().isBlank()) {
            for (String s : this.getTargetIds().split(";")) {
                Entity entity = this.level().getEntity(Integer.parseInt(s));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity e = (LivingEntity)entity;
                this.entitiesToAttack.add(e);
            }
        }
    }

    @Override
    public boolean isPersistenceRequired() {
        return true;
    }

    public void setActive(boolean active) {
        this.entityData.set(ACTIVE, (Object)active);
    }

    public String getTargetIds() {
        return (String)this.entityData.get(TARGET_IDS);
    }

    public void setTargetIds(String uuid) {
        this.entityData.set(TARGET_IDS, (Object)uuid);
    }

    public boolean isActiveForAttack() {
        return (Boolean)this.entityData.get(ATTACK_ACTIVE);
    }

    public void setActiveForAttack(boolean active) {
        this.entityData.set(ATTACK_ACTIVE, (Object)active);
    }

    public int getAnimationStartTick() {
        return (Integer)this.entityData.get(ANIMATION_START_TICK);
    }

    public void setAnimationStartTick(int tick) {
        this.entityData.set(ANIMATION_START_TICK, (Object)tick);
    }

    public int getCycleCounter() {
        return (Integer)this.entityData.get(CYCLE_COUNTER);
    }

    public void setCycleCounter(int tick) {
        this.entityData.set(CYCLE_COUNTER, (Object)tick);
    }

    public int getAttackCycleCounter() {
        return (Integer)this.entityData.get(ATTACK_CYCLE_COUNTER);
    }

    public void setAttackCycleCounter(int tick) {
        this.entityData.set(ATTACK_CYCLE_COUNTER, (Object)tick);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    public boolean shouldAttack() {
        return (Boolean)this.entityData.get(SHOULD_ATTACK);
    }

    public void setShouldAttack(boolean shouldAttack) {
        this.entityData.set(SHOULD_ATTACK, (Object)shouldAttack);
    }

    public void handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect) {
        this.connectionManager.addConnection(thisNode, nodeToConnect);
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.playStepSound(pPos, pState);
        this.playSound(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
        this.playSound(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int getAmbientSoundInterval() {
        return 400;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVE, (Object)false);
        builder.define(CYCLE_COUNTER, (Object)0);
        builder.define(ANIMATION_START_TICK, (Object)0);
        builder.define(ATTACK_ACTIVE, (Object)true);
        builder.define(ATTACK_CYCLE_COUNTER, (Object)0);
        builder.define(SHOULD_ATTACK, (Object)true);
        builder.define(TARGET_IDS, (Object)"");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate));
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

