/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.FlyingNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.mage.allay.control.GoldenAllayMoveControl;
import dev.xylonity.companions.common.entity.ai.mage.allay.goal.GoldenAllayRandomMoveGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoldenAllayEntity
extends CompanionEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("fly_idle");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation LEVITATE = RawAnimation.begin().thenPlay("levitate");
    private final RawAnimation HAT = RawAnimation.begin().thenPlay("hat");
    private final RawAnimation SHIRT = RawAnimation.begin().thenPlay("tshirt");
    private final RawAnimation TRANSFORM = RawAnimation.begin().thenPlay("transform");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(GoldenAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int TRANSFORMATION_ANIMATION_TICKS = 80;
    private static final int HAT_ANIMATION_TICKS = 20;
    private static final int SHIRT_ANIMATION_TICKS = 15;
    private int transformationCounter;
    private int shirtCounter;
    private int hatCounter;

    public GoldenAllayEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new GoldenAllayMoveControl(this);
        this.transformationCounter = -1;
        this.shirtCounter = -1;
        this.hatCounter = -1;
    }

    @Override
    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (this.tickCount % 20 == 0 && this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)CompanionsParticles.GOLDEN_ALLAY_TRAIL.get(), this.getX(), this.getY(), this.getZ(), 0.35, 0.35, 0.35);
        }
        if (!this.level().isClientSide) {
            if (this.getState() == 1 && this.shirtCounter == -1) {
                ++this.shirtCounter;
            }
            if (this.getState() == 3 && this.hatCounter == -1) {
                ++this.hatCounter;
            }
            if (this.getState() == 5 && this.transformationCounter == -1) {
                ++this.transformationCounter;
            }
            if (this.shirtCounter != -1) {
                ++this.shirtCounter;
            }
            if (this.hatCounter != -1) {
                ++this.hatCounter;
            }
            if (this.transformationCounter != -1) {
                ++this.transformationCounter;
            }
            if (this.shirtCounter == 15) {
                this.cycleState();
                this.generatePoofParticles();
                this.shirtCounter = -1;
            }
            if (this.hatCounter == 20) {
                this.cycleState();
                this.generatePoofParticles();
                this.hatCounter = -1;
            }
            if (this.transformationCounter == 80) {
                SoulMageEntity mage = (SoulMageEntity)CompanionsEntities.SOUL_MAGE.get().create(this.level());
                if (mage != null) {
                    mage.moveTo(this.position());
                    LivingEntity livingEntity = this.getOwner();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        mage.tameInteraction(player);
                    } else if (this.getOwnerUUID() != null) {
                        mage.setOwnerUUID(this.getOwnerUUID());
                    }
                    this.level().addFreshEntity((Entity)mage);
                    SoulMageBookEntity book = (SoulMageBookEntity)CompanionsEntities.SOUL_MAGE_BOOK.get().create(this.level());
                    if (book != null) {
                        book.moveTo(this.position());
                        book.setOwner((Entity)mage);
                        this.level().addFreshEntity((Entity)book);
                    }
                }
                this.generatePoofParticles();
                this.discard();
            }
        }
        if (this.level().isClientSide) {
            Companions.PROXY.spawnGoldenAllayRibbonTrail((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, 0.627451f, 0.0f, 0.1225f);
        }
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.25;
            double dy = (this.random.nextDouble() - 0.5) * 1.25;
            double dz = (this.random.nextDouble() - 0.5) * 1.25;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.getY() + (double)this.getBbHeight() * Math.random(), this.position().z, 1, dx, dy, dz, 0.1);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        FlyingNavigator navigation = new FlyingNavigator((Mob)this, this.level());
        navigation.setCanOpenDoors(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GoldenAllayRandomMoveGoal(this));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 6.0f, (double)0.6f, 1.0));
        this.goalSelector.addGoal(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.ALLAY_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ALLAY_DEATH;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("State")) {
            this.setState(pCompound.getInt("State"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("State", this.getState());
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 1 || this.getState() == 3 || this.getState() == 5) {
            return InteractionResult.PASS;
        }
        if (pPlayer.getUUID().equals(this.getOwnerUUID()) || this.getOwnerUUID() == null) {
            ItemStack stack = pPlayer.getItemInHand(pHand);
            return switch (this.getState()) {
                case 0 -> this.giveFirstItem(pPlayer, pHand, stack);
                case 2 -> this.giveSecondItem(pPlayer, pHand, stack);
                default -> this.giveThirdItem(pPlayer, pHand, stack);
            };
        }
        return super.mobInteract(pPlayer, pHand);
    }

    private InteractionResult giveFirstItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == CompanionsItems.MAGE_COAT.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_coat_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_mage_coat");
    }

    private InteractionResult giveSecondItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == CompanionsItems.MAGE_HAT.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_hat_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_hat_coat");
    }

    private InteractionResult giveThirdItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == CompanionsItems.MAGE_STAFF.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_staff_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_staff_coat");
    }

    private InteractionResult handleGoodInteraction(Player pPlayer, InteractionHand pHand, ItemStack stack, String translationPrefix) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.getAbilities().instabuild) {
            stack.shrink(1);
        }
        this.cycleState();
        if (this.getOwnerUUID() == null) {
            this.setOwnerUUID(pPlayer.getUUID());
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)("golden_allay.companions.client_message." + translationPrefix)), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleBadInteraction(Player pPlayer, InteractionHand pHand, ItemStack stack, String translationPrefix) {
        pPlayer.displayClientMessage((Component)Component.translatable((String)("golden_allay.companions.client_message." + translationPrefix)), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    public static boolean checkGoldenAllaySpawnRules(EntityType<GoldenAllayEntity> allay, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return GoldenAllayEntity.isDarkEnoughToSpawn(pLevel, pPos, pRandom);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        DimensionType dimensionType = level.dimensionType();
        int i = dimensionType.monsterSpawnBlockLightLimit();
        if (i < 15 && level.getBrightness(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.getLevel().isThundering() ? level.getMaxLocalRawBrightness(pos, 10) : level.getMaxLocalRawBrightness(pos);
        return j <= dimensionType.monsterSpawnLightTest().sample(random);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 0;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    public void cycleState() {
        this.entityData.set(STATE, (Object)(this.getState() + 1));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "levitateController", this::levitatePredicate));
    }

    private <T extends GeoAnimatable> PlayState levitatePredicate(AnimationState<T> event) {
        event.getController().setAnimation(this.LEVITATE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() == 5) {
            event.getController().setAnimation(this.TRANSFORM);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.HAT);
        } else if (this.getState() == 1) {
            event.getController().setAnimation(this.SHIRT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.FLY);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

