/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleHealAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleSpellAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.minion.MinionTornadoAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MinionEntity
extends CompanionEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation SPELL = RawAnimation.begin().thenPlay("spell");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private final RawAnimation HEAL = RawAnimation.begin().thenPlay("idle2");
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.defineId(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.defineId(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ResourceKey<Level> lastDimension = null;

    public MinionEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.MINION_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MinionTornadoAttackGoal(this, 20, 80));
        this.goalSelector.addGoal(1, (Goal)new ImpBraceAttackGoal(this, 20, 80));
        this.goalSelector.addGoal(1, (Goal)new ImpFireMarkAttackGoal(this, 20, 80));
        this.goalSelector.addGoal(1, (Goal)new GargoyleSpellAttackGoal(this, 20, 80));
        this.goalSelector.addGoal(1, (Goal)new GargoyleHealAttackGoal(this, 20, 80));
        this.goalSelector.addGoal(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.goalSelector.addGoal(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    private void updateVariantByDimension() {
        if (this.isPhaseLocked()) {
            return;
        }
        ResourceKey currentDim = this.level().dimension();
        if (currentDim.equals(this.lastDimension)) {
            return;
        }
        this.lastDimension = currentDim;
        Variant newVariant = currentDim.equals(Level.NETHER) ? Variant.NETHER : (currentDim.equals(Level.END) ? Variant.END : Variant.OVERWORLD);
        this.setVariant(newVariant.getName());
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner() && player.getItemInHand(hand).getItem() == CompanionsItems.NETHERITE_CHAINS.get() && !this.isPhaseLocked()) {
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(hand).shrink(1);
            }
            this.tameParticles();
            this.playSound(CompanionsSounds.SPELL_RELEASE_MARK.get());
            this.setIsPhaseLocked(true);
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner()) {
            if (Variant.NETHER.getName().equals(this.getVariant()) && player.getItemInHand(hand).getItem() == CompanionsBlocks.NETHER_COIN.get().asItem()) {
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                if (this.getRandom().nextFloat() < 0.45f) {
                    MinionEntity.popResource(this.level(), new BlockPos(this.blockPosition().getX(), this.blockPosition().getY() + 1, this.blockPosition().getZ()), new ItemStack(this.getRandom().nextBoolean() ? (ItemLike)CompanionsItems.BOOK_FIRE_MARK.get() : (ItemLike)CompanionsItems.BOOK_BRACE.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
            if (Variant.END.getName().equals(this.getVariant()) && player.getItemInHand(hand).getItem() == CompanionsBlocks.END_COIN.get().asItem()) {
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                if (this.getRandom().nextFloat() < 0.55f) {
                    MinionEntity.popResource(this.level(), new BlockPos(this.blockPosition().getX(), this.blockPosition().getY() + 1, this.blockPosition().getZ()), new ItemStack(this.getRandom().nextBoolean() ? (ItemLike)CompanionsItems.BOOK_HEAL_RING.get() : (ItemLike)CompanionsItems.BOOK_STONE_SPIKES.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
            if (Variant.OVERWORLD.getName().equals(this.getVariant()) && player.getItemInHand(hand).getItem() == CompanionsBlocks.COPPER_COIN.get().asItem()) {
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                if (this.getRandom().nextFloat() < 0.25f) {
                    MinionEntity.popResource(this.level(), new BlockPos(this.blockPosition().getX(), this.blockPosition().getY() + 1, this.blockPosition().getZ()), new ItemStack(this.getRandom().nextBoolean() ? (ItemLike)CompanionsItems.BOOK_ICE_SHARD.get() : (ItemLike)CompanionsItems.BOOK_ICE_TORNADO.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.ITEM.getHeight() / 2.0f;
        double d1 = (double)pPos.getX() + 0.5;
        double d2 = (double)pPos.getY() + 1.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.getZ() + 0.5;
        MinionEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.isClientSide && !pStack.isEmpty()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.updateVariantByDimension();
        }
    }

    public boolean fireImmune() {
        return this.getVariant().equals(Variant.NETHER.getName());
    }

    private void rewardParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.random.nextFloat() < 0.65f)) continue;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.random.nextFloat() < 0.65f)) continue;
            level2.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.025);
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_DEATH.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_DEATH.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_HURT.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_HURT.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return super.getAmbientSound();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_IDLE.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_IDLE.get();
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
        if (this.getVariant().equals(Variant.END.getName())) {
            this.playSound(CompanionsSounds.END_MINION_STEP.get(), 0.5f, 1.0f);
        } else {
            super.playStepSound(pPos, pState);
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setIsPhaseLocked(pCompound.getBoolean("IsVariantLocked"));
        if (pCompound.contains("Variant", 8)) {
            this.setVariant(pCompound.getString("Variant"));
        } else {
            ResourceKey dim = this.level().dimension();
            if (dim.equals(Level.NETHER)) {
                this.setVariant(Variant.NETHER.getName());
            } else if (dim.equals(Level.END)) {
                this.setVariant(Variant.END.getName());
            } else {
                this.setVariant(Variant.OVERWORLD.getName());
            }
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("IsVariantLocked", this.isPhaseLocked());
        pCompound.putString("Variant", this.getVariant());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)Variant.OVERWORLD.getName());
        builder.define(IS_LOCKED, (Object)false);
        builder.define(IS_FLYING, (Object)false);
        builder.define(ATTACK_TYPE, (Object)0);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.MINION_KEEP_CHUNK_LOADED;
    }

    public boolean isPhaseLocked() {
        return (Boolean)this.entityData.get(IS_LOCKED);
    }

    public void setIsPhaseLocked(boolean phase) {
        this.entityData.set(IS_LOCKED, (Object)phase);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(IS_FLYING, (Object)flying);
    }

    public String getVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public void setVariant(String variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.entityData.set(ATTACK_TYPE, (Object)attacking);
    }

    @NotNull
    public Component getName() {
        if (this.hasCustomName()) {
            return super.getName();
        }
        if (Variant.NETHER.getName().equals(this.getVariant())) {
            return Component.translatable((String)"entity.companions.imp");
        }
        if (Variant.END.getName().equals(this.getVariant())) {
            return Component.translatable((String)"entity.companions.gargoyle");
        }
        return Component.translatable((String)"entity.companions.minion");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getVariant().equals(Variant.OVERWORLD.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.ATTACK);
            } else {
                event.getController().setAnimation(this.FLY);
            }
        } else if (this.getVariant().equals(Variant.END.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.SPELL);
            } else if (this.getAttackType() == 2) {
                event.getController().setAnimation(this.HEAL);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.65f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.25f)) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.2);
        }
    }

    public static enum Variant {
        OVERWORLD("minion"),
        NETHER("imp"),
        END("gargoyle");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

