/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrokenDinamoEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE1 = RawAnimation.begin().thenPlay("broken1");
    private final RawAnimation IDLE2 = RawAnimation.begin().thenPlay("broken2");
    private final RawAnimation FIX1 = RawAnimation.begin().thenPlay("fixing1");
    private final RawAnimation FIX2 = RawAnimation.begin().thenPlay("fixing2");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(BrokenDinamoEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final int ANIMATION_FIX_TICKS = 40;
    private int animationCounter = -1;
    private int woodAmount = 10 + this.getRandom().nextInt(10, 30);
    private int ironAmount = 10 + this.getRandom().nextInt(10, 30);
    private boolean confirmationCheck = false;

    public BrokenDinamoEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        double prevX = this.getX();
        double prevZ = this.getZ();
        super.tick();
        if (!this.level().isClientSide) {
            if ((this.getState() == 3 || this.getState() == 7) && this.animationCounter == -1) {
                ++this.animationCounter;
            }
            if (this.animationCounter >= 40) {
                if (this.getState() == 3) {
                    this.animationCounter = -1;
                    this.cycleState();
                } else {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (this.getOwnerUUID() != null) {
                            this.tameDinamo(serverLevel.getEntity(this.getOwnerUUID()));
                        }
                    }
                    this.discard();
                }
                this.level().playSound(null, this.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generatePoofParticles();
            }
            if (this.animationCounter != -1) {
                ++this.animationCounter;
            }
            if (this.tickCount >= this.getLifetime() && this.getLifetime() != -1) {
                this.generatePoofParticles();
                this.discard();
            }
        }
        this.setPos(prevX, this.getY(), prevZ);
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 3 || this.getState() == 7) {
            return InteractionResult.PASS;
        }
        if (pPlayer.getUUID().equals(this.getOwnerUUID()) || this.getOwnerUUID() == null) {
            ItemStack stack = pPlayer.getItemInHand(pHand);
            return switch (this.getState()) {
                case 0 -> this.giveFirstItem(pPlayer, pHand, stack);
                case 1 -> this.giveSecondItem(pPlayer, pHand, stack);
                case 4 -> this.giveThirdItem(pPlayer, pHand, stack);
                case 5 -> this.giveFourthItem(pPlayer, pHand, stack);
                default -> this.wrenchInteract(pPlayer, pHand, stack);
            };
        }
        return super.mobInteract(pPlayer, pHand);
    }

    private void tameDinamo(Entity e) {
        if (e instanceof Player) {
            Player player = (Player)e;
            DinamoEntity dinamo = (DinamoEntity)CompanionsEntities.DINAMO.get().create(this.level());
            if (dinamo != null) {
                dinamo.moveTo(this.position());
                dinamo.tameInteraction(player);
                this.level().addFreshEntity((Entity)dinamo);
            }
        }
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.25;
            double dy = (this.random.nextDouble() - 0.5) * 1.25;
            double dz = (this.random.nextDouble() - 0.5) * 1.25;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.getY() + (double)this.getBbHeight() * Math.random(), this.position().z, 1, dx, dy, dz, 0.1);
        }
    }

    private void generateWaxParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, this.position().x, this.getY() + (double)(this.getBbHeight() * 0.5f), this.position().z, 8, 0.75, 0.75, 0.75, 0.065);
        }
    }

    private InteractionResult giveFirstItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == Items.OAK_PLANKS && stack.getCount() >= this.woodAmount) {
            if (this.confirmationCheck) {
                if (this.level().isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(this.woodAmount);
                }
                this.cycleState();
                this.confirmationCheck = false;
                if (this.getOwnerUUID() == null) {
                    this.setOwnerUUID(pPlayer.getUUID());
                }
                pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.wood_consumed", (Object[])new Object[]{Component.literal((String)String.valueOf(this.woodAmount)).withStyle(ChatFormatting.ITALIC)}), true);
                pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generateWaxParticles();
                return InteractionResult.SUCCESS;
            }
        } else {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.requires_wood", (Object[])new Object[]{Component.literal((String)String.valueOf(this.woodAmount)).withStyle(ChatFormatting.ITALIC)}), true);
            pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.wood_will_get_consumed", (Object[])new Object[]{Component.literal((String)String.valueOf(this.woodAmount)).withStyle(ChatFormatting.ITALIC)}), true);
        this.confirmationCheck = true;
        return InteractionResult.SUCCESS;
    }

    private InteractionResult giveSecondItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == KnightLibItems.HOMUNCULUS.get()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.cycleState();
            pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.homunculus_consumed"), true);
            pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.generateWaxParticles();
            return InteractionResult.SUCCESS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.requires_homunculus"), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    private InteractionResult giveThirdItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == Items.IRON_INGOT && stack.getCount() >= this.ironAmount) {
            if (this.confirmationCheck) {
                if (this.level().isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(this.ironAmount);
                }
                this.cycleState();
                this.confirmationCheck = false;
                if (this.getOwnerUUID() == null) {
                    this.setOwnerUUID(pPlayer.getUUID());
                }
                pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.iron_consumed", (Object[])new Object[]{Component.literal((String)String.valueOf(this.ironAmount)).withStyle(ChatFormatting.ITALIC)}), true);
                pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.generateWaxParticles();
                return InteractionResult.SUCCESS;
            }
        } else {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.requires_iron", (Object[])new Object[]{Component.literal((String)String.valueOf(this.ironAmount)).withStyle(ChatFormatting.ITALIC)}), true);
            pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.iron_will_get_consumed", (Object[])new Object[]{Component.literal((String)String.valueOf(this.ironAmount)).withStyle(ChatFormatting.ITALIC)}), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.confirmationCheck = true;
        return InteractionResult.SUCCESS;
    }

    private InteractionResult giveFourthItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == CompanionsBlocks.TESLA_COIL.get().asItem()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.cycleState();
            pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.tesla_coil_consumed"), true);
            pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.generateWaxParticles();
            return InteractionResult.SUCCESS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.requires_tesla_coil"), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    private InteractionResult wrenchInteract(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.getItem() == CompanionsItems.WRENCH.get()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!pPlayer.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            this.cycleState();
            pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"broken_dinamo.companions.client_message.requires_wrench"), true);
        pPlayer.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getState() != 2 ? super.getDefaultDimensions(pose) : EntityDimensions.scalable((float)1.0f, (float)1.0f);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void cycleState() {
        this.entityData.set(STATE, (Object)(this.getState() + 1));
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public void setLifetime(int lifetime) {
        this.entityData.set(LIFETIME, (Object)lifetime);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(LIFETIME, (Object)-1);
        builder.define(OWNER_UUID, Optional.empty());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Lifetime")) {
            this.setLifetime(pCompound.getInt("Lifetime"));
        }
        if (pCompound.contains("State")) {
            this.setState(pCompound.getInt("State"));
        }
        if (pCompound.contains("WoodAmount")) {
            this.woodAmount = pCompound.getInt("WoodAmount");
        }
        if (pCompound.contains("IronAmount")) {
            this.ironAmount = pCompound.getInt("IronAmount");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Lifetime", this.getLifetime());
        pCompound.putInt("State", this.getState());
        pCompound.putInt("WoodAmount", this.woodAmount);
        pCompound.putInt("IronAmount", this.ironAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() == 7) {
            event.getController().setAnimation(this.FIX2);
        } else if (this.getState() == 4 || this.getState() == 5 || this.getState() == 6) {
            event.getController().setAnimation(this.IDLE2);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.FIX1);
        } else if (this.getState() == 0 || this.getState() == 1 || this.getState() == 2) {
            event.getController().setAnimation(this.IDLE1);
        }
        return PlayState.CONTINUE;
    }
}

