/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessDoubleThrowAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessImpactAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessStakeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.HolinessStarAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffDashAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffNearestAttackableTargetGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffRotatingFireRayGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffStaffKnockAttackGoal;
import dev.xylonity.companions.common.entity.ai.pontiff.goal.PontiffStrafeAroundTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.IBossMusicProvider;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SacredPontiffEntity
extends HostileEntity
implements IBossMusicProvider {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation INACTIVE = RawAnimation.begin().thenPlay("inactive");
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private final RawAnimation UP_ATTACK = RawAnimation.begin().thenPlay("up_attack");
    private final RawAnimation FRONT_ATTACK = RawAnimation.begin().thenPlay("front_attack");
    private final RawAnimation HOLD_ATTACK = RawAnimation.begin().thenPlay("hold_attack");
    private final RawAnimation AREA_ATTACK = RawAnimation.begin().thenPlay("area_attack");
    private final RawAnimation TRANSFORMATION = RawAnimation.begin().thenPlay("transformation");
    private final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private final RawAnimation STAB = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation STAKE = RawAnimation.begin().thenPlay("stake");
    private final RawAnimation DOUBLE_THROW = RawAnimation.begin().thenPlay("double_throw");
    private final RawAnimation IMPACT = RawAnimation.begin().thenPlay("impact");
    private final RawAnimation STAR_ATTACK = RawAnimation.begin().thenPlay("star_attack");
    private final RawAnimation PHASE2_DIE = RawAnimation.begin().thenPlay("die");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE_COUNTER = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> APPEAR_ANIMATION = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOULD_ATTACK = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOULD_LOOK_AT_TARGET = SynchedEntityData.defineId(SacredPontiffEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ANIMATION_ACTIVATION_MAX_TICKS = 65;
    private static final int ANIMATION_PHASE2_DEAD_MAX_TICKS = 153;
    private static final int ANIMATION_PHASE1_DEAD_MAX_TICKS = 166;
    private static final int ANIMATION_PHASE2_APPEAR_MAX_TICKS = 158;
    private static final int INVISIBLE_MAX_TICKS = 60;
    private boolean hasRegisteredBossBar = false;
    private int attackCounter;
    private int lastAttackType;
    private int transformationCounter;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final Set<Integer> SHAKE_TICKS = Set.of(Integer.valueOf(70), Integer.valueOf(80), Integer.valueOf(93), Integer.valueOf(104), Integer.valueOf(117), Integer.valueOf(128), Integer.valueOf(159));

    public SacredPontiffEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
        this.setNoMovement(true);
        this.bossInfo.setCreateWorldFog(true);
        this.attackCounter = 0;
        this.lastAttackType = 0;
        this.transformationCounter = 0;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PontiffRotatingFireRayGoal(this, 200, 500));
        this.goalSelector.addGoal(1, (Goal)new PontiffMeleeAttackGoal(this, 10, 60));
        this.goalSelector.addGoal(1, (Goal)new PontiffStaffKnockAttackGoal(this, 160, 360));
        this.goalSelector.addGoal(1, (Goal)new PontiffDashAttackGoal(this, 60, 200));
        this.goalSelector.addGoal(1, (Goal)new HolinessMeleeAttackGoal(this, 40, 100));
        this.goalSelector.addGoal(1, (Goal)new HolinessStakeAttackGoal(this, 60, 140));
        this.goalSelector.addGoal(1, (Goal)new HolinessDoubleThrowAttackGoal(this, 200, 700));
        this.goalSelector.addGoal(1, (Goal)new HolinessImpactAttackGoal(this, 160, 600));
        this.goalSelector.addGoal(1, (Goal)new HolinessStarAttackGoal(this, 200, 500));
        this.goalSelector.addGoal(2, (Goal)new PontiffStrafeAroundTargetGoal(this, 0.5, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                return super.canUse() && SacredPontiffEntity.this.shouldSearchTarget();
            }
        });
        this.targetSelector.addGoal(2, new PontiffNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.targetSelector.addGoal(2, new PontiffNearestAttackableTargetGoal<TamableAnimal>(this, TamableAnimal.class, true));
        this.targetSelector.addGoal(2, new PontiffNearestAttackableTargetGoal<Turtle>(this, Turtle.class, true));
    }

    @Override
    public void tick() {
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.getState() == 2 && !this.hasRegisteredBossBar) {
            this.hasRegisteredBossBar = true;
            this.bossInfo.setName(this.getDisplayName());
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer p : serverLevel.getPlayers(p2 -> true)) {
                    if (!(p.distanceToSqr((Entity)this) < 4096.0)) continue;
                    this.bossInfo.addPlayer(p);
                }
            }
        }
        if (this.getState() == 5) {
            this.heal(this.getMaxHealth() / 158.0f);
        }
        if (this.getTicksFrozen() > 0) {
            this.setTicksFrozen(0);
        }
        if (this.hasEffect(MobEffects.LEVITATION)) {
            this.removeEffect(MobEffects.LEVITATION);
        }
        if (this.getState() >= 3 && this.getState() <= 5) {
            if (this.getState() == 3) {
                if (this.level().isClientSide && this.transformationCounter == 130) {
                    for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                        if (!this.level().isClientSide) continue;
                        Companions.PROXY.shakePlayerCamera(player, 50, 0.045f, 0.045f, 0.045f, 30);
                    }
                } else if (!this.level().isClientSide && this.transformationCounter == 120) {
                    this.playSound(CompanionsSounds.PONTIFF_DESPAWN.get(), 0.5f, 1.0f);
                }
            }
            if (this.getState() == 5 && !this.level().isClientSide && this.transformationCounter == 15) {
                this.playSound(CompanionsSounds.HOLINESS_APPEAR.get(), 0.5f, 1.0f);
            }
            ++this.transformationCounter;
        }
        if (this.getState() >= 5 && this.getAttackType() == 4) {
            if (this.level().isClientSide && this.attackCounter == 35) {
                for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                    if (!this.level().isClientSide) continue;
                    Companions.PROXY.shakePlayerCamera(player, 50, 0.045f, 0.045f, 0.045f, 30);
                }
            } else if (!this.level().isClientSide && this.attackCounter == 35) {
                this.playSound(CompanionsSounds.HOLINESS_HIT_GROUND.get(), 14.0f, 1.0f);
            }
        }
        if (this.getState() == 5 && SHAKE_TICKS.contains(this.getStateCounter())) {
            for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                if (this.level().isClientSide) {
                    Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
                    continue;
                }
                this.playSound(CompanionsSounds.HOLINESS_HIT_CHEST.get(), 2.0f, 1.0f);
            }
        }
        super.tick();
        if (!this.level().isClientSide) {
            this.stateMachine();
        }
        if (this.getAttackType() != 0) {
            if (this.getAttackType() != this.lastAttackType) {
                this.lastAttackType = this.getAttackType();
                this.attackCounter = 0;
            }
            ++this.attackCounter;
        } else {
            this.attackCounter = 0;
        }
    }

    public void push(double pX, double pY, double pZ) {
    }

    private void stateMachine() {
        if (this.getState() == 1) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 65) {
                this.cycleState();
                this.setNoMovement(false);
            }
        } else if (this.getState() == 3) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 166) {
                this.cycleState();
                this.setInvisible(true);
                this.bossInfo.setName((Component)Component.translatable((String)"entity.companions.sacred_pontiff_invisible"));
            }
        } else if (this.getState() == 4) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 60) {
                AttributeInstance newDmg;
                this.cycleState();
                this.bossInfo.setName(this.getName());
                AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
                if (maxHealth != null) {
                    maxHealth.setBaseValue(CompanionsConfig.HIS_HOLINESS_MAX_LIFE);
                }
                if ((newDmg = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                    newDmg.setBaseValue(CompanionsConfig.HIS_HOLINESS_DAMAGE);
                }
            }
        } else if (this.getState() == 5) {
            if (this.getStateCounter() == -1) {
                this.setStateCounter(0);
            }
            if (this.getStateCounter() == 2) {
                this.setInvisible(false);
            }
            if (this.getStateCounter() == 158) {
                this.cycleState();
                this.setNoMovement(false);
            }
        }
        if (this.getStateCounter() != -1 && this.getState() != 0) {
            this.setStateCounter(this.getStateCounter() + 1);
        }
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.PONTIFF_HURT.get();
    }

    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.PONTIFF_IDLE.get();
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(CompanionsSounds.PONTIFF_STEP.get(), 0.55f, 1.0f);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.SACRED_PONTIFF_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.SACRED_PONTIFF_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.45f).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        if (this.getState() >= 1) {
            this.bossInfo.addPlayer(pPlayer);
        }
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossInfo.removePlayer(pPlayer);
    }

    public int getStateCounter() {
        return (Integer)this.entityData.get(STATE_COUNTER);
    }

    public void setStateCounter(int counter) {
        this.entityData.set(STATE_COUNTER, (Object)counter);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void cycleState() {
        this.entityData.set(STATE, (Object)(this.getState() + 1));
        this.setStateCounter(-1);
        this.transformationCounter = 0;
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public boolean shouldSearchTarget() {
        return this.getState() == 2 || this.getState() == 6;
    }

    public boolean shouldAttack() {
        return (Boolean)this.entityData.get(SHOULD_ATTACK);
    }

    public boolean shouldLookAtTarget() {
        return (Boolean)this.entityData.get(SHOULD_LOOK_AT_TARGET);
    }

    public void setShouldLookAtTarget(boolean shouldLookAtTarget) {
        this.entityData.set(SHOULD_LOOK_AT_TARGET, (Object)shouldLookAtTarget);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 0) {
            this.cycleState();
            this.playSound(CompanionsSounds.PONTIFF_ACTIVATE.get());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (this.getState() == 0 || this.getState() == 1 || this.getState() == 3 || this.getState() == 4 || this.getState() == 5) {
            return false;
        }
        if (this.getHealth() - pAmount <= 0.0f && this.getState() == 2) {
            this.cycleState();
            this.playSound(CompanionsSounds.PONTIFF_GROUND_DESPAWN.get());
            this.setHealth(0.1f);
            this.setNoMovement(true);
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public void knockback(double pStrength, double pX, double pZ) {
    }

    @NotNull
    public Component getName() {
        if (this.getState() >= 5) {
            return Component.translatable((String)"entity.companions.his_holiness");
        }
        return Component.translatable((String)"entity.companions.sacred_pontiff");
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 1 && !this.level().isClientSide) {
            this.setNoMovement(true);
            this.playSound(CompanionsSounds.HOLINESS_DEATH.get(), 2.0f, 1.0f);
        }
        if (this.deathTime >= 153 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.spawnAtLocation(new ItemStack((ItemLike)CompanionsItems.RELIC_GOLD.get(), this.getRandom().nextInt(2, 10)));
            this.spawnAtLocation(new ItemStack((ItemLike)CompanionsItems.OLD_CLOTH.get(), this.getRandom().nextInt(2, 10)));
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(STATE_COUNTER, (Object)-1);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(APPEAR_ANIMATION, (Object)false);
        builder.define(SHOULD_ATTACK, (Object)true);
        builder.define(SHOULD_LOOK_AT_TARGET, (Object)true);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getState() <= 3 ? super.getDefaultDimensions(pose) : EntityDimensions.scalable((float)1.0f, (float)2.0f);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("State")) {
            this.setState(pCompound.getInt("State"));
        }
        if (pCompound.contains("IsInvisible")) {
            this.setInvisible(pCompound.getBoolean("IsInvisible"));
        }
        if (this.getDisplayName() != null) {
            this.bossInfo.setName(this.getDisplayName());
        }
        this.setStateCounter(-1);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("State", this.getState());
        pCompound.putInt("StateCounter", this.getStateCounter());
        pCompound.putBoolean("IsInvisible", this.isInvisible());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() >= 5) {
            if (this.isDeadOrDying()) {
                event.setAnimation(this.PHASE2_DIE);
            } else if (this.getState() == 5) {
                event.setAnimation(this.APPEAR);
            } else if (this.getAttackType() == 1) {
                event.setAnimation(this.STAB);
            } else if (this.getAttackType() == 2) {
                event.setAnimation(this.STAKE);
            } else if (this.getAttackType() == 3) {
                event.setAnimation(this.DOUBLE_THROW);
            } else if (this.getAttackType() == 4) {
                event.setAnimation(this.IMPACT);
            } else if (this.getAttackType() == 5) {
                event.setAnimation(this.STAR_ATTACK);
            } else if (event.isMoving()) {
                event.setAnimation(this.WALK);
            } else {
                event.setAnimation(this.IDLE);
            }
        } else if (this.getState() == 0) {
            event.setAnimation(this.INACTIVE);
        } else if (this.getState() == 1) {
            event.setAnimation(this.ACTIVATE);
        } else if (this.getState() == 3) {
            event.setAnimation(this.TRANSFORMATION);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.UP_ATTACK);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.FRONT_ATTACK);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.HOLD_ATTACK);
        } else if (this.getAttackType() == 4) {
            event.setAnimation(this.AREA_ATTACK);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    public SoundEvent getBossMusic() {
        return CompanionsSounds.SAINT_KLIMT.get();
    }

    public boolean shouldPlayBossMusic(Player listener) {
        if (!this.isAlive()) {
            return false;
        }
        if (this.getState() < 2) {
            return false;
        }
        return !(this.distanceToSqr((Entity)listener) > this.getMusicRangeSqr());
    }
}

