/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class BloodTornadoProjectile
extends BaseProjectile {
    private final RawAnimation SPIN = RawAnimation.begin().thenPlay("spin");
    private static final EntityDataAccessor<Float> GROUNDY = SynchedEntityData.defineId(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STARTX = SynchedEntityData.defineId(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STARTZ = SynchedEntityData.defineId(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.defineId(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TICKS = SynchedEntityData.defineId(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean initialized = false;

    public BloodTornadoProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GROUNDY, (Object)Float.valueOf(0.0f));
        builder.define(STARTX, (Object)Float.valueOf(0.0f));
        builder.define(STARTZ, (Object)Float.valueOf(0.0f));
        builder.define(TICKS, (Object)0);
        builder.define(ALPHA, (Object)Float.valueOf(Float.NaN));
    }

    public float getGroundY() {
        return ((Float)this.entityData.get(GROUNDY)).floatValue();
    }

    public void setGroundY(float v) {
        this.entityData.set(GROUNDY, (Object)Float.valueOf(v));
    }

    public float getStartX() {
        return ((Float)this.entityData.get(STARTX)).floatValue();
    }

    public void setStartX(float v) {
        this.entityData.set(STARTX, (Object)Float.valueOf(v));
    }

    public float getStartZ() {
        return ((Float)this.entityData.get(STARTZ)).floatValue();
    }

    public void setStartZ(float v) {
        this.entityData.set(STARTZ, (Object)Float.valueOf(v));
    }

    public float getAlpha() {
        return ((Float)this.entityData.get(ALPHA)).floatValue();
    }

    public void setAlpha(float v) {
        this.entityData.set(ALPHA, (Object)Float.valueOf(v));
    }

    public int getTicks() {
        return (Integer)this.entityData.get(TICKS);
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide) {
            this.entityData.set(TICKS, (Object)this.tickCount);
        }
        super.tick();
        if (!this.initialized) {
            this.setGroundY((float)this.getY());
            this.setStartX((float)this.getX());
            this.setStartZ((float)this.getZ());
            if (Float.isNaN(this.getAlpha())) {
                Vec3 dir = this.getDeltaMovement().normalize();
                this.setAlpha((float)Math.atan2(dir.z, dir.x));
            }
            this.setNoGravity(true);
            this.initialized = true;
        }
        double t = (double)this.getTicks() * 0.2;
        double xLocal = 2.0 * Math.sin(1.5707963267948966 * t);
        double zLocal = t;
        double cosA = Math.cos(this.getAlpha());
        double sinA = Math.sin(this.getAlpha());
        this.setPos((double)this.getStartX() + (xLocal * cosA - zLocal * sinA), this.getGroundY(), (double)this.getStartZ() + (xLocal * sinA + zLocal * cosA));
        this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(1.0), e -> !Util.areEntitiesLinked((Entity)this, e)).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.hurt(this.damageSources().magic(), (float)CompanionsConfig.BLOOD_TORNADO_DAMAGE);
            }
        });
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            Random random = new Random();
            if ((double)random.nextFloat() <= 0.15) {
                sv.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX() + (double)(this.getBbWidth() * 2.0f) * Math.random(), this.getY() + (double)(this.getBbHeight() * 2.0f) * Math.random(), this.getZ() + (double)(this.getBbWidth() * 2.0f) * Math.random(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.level().isClientSide && (this.tickCount % 35 == 0 || this.tickCount == 1)) {
            for (int i = 0; i < 3; ++i) {
                Companions.PROXY.spawnBaseProjectileTrail((Entity)this, this.getBbHeight() - 0.25f, this.getBbHeight(), 0.5294118f, 0.0f, 0.0f);
            }
        }
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide) {
            this.spawnRemoveParticles();
            this.level().playSound(null, this.blockPosition(), SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.NEUTRAL);
        }
        super.remove(pReason);
    }

    private void spawnRemoveParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.15;
            double dy = (this.random.nextDouble() - 0.5) * 1.15;
            double dz = (this.random.nextDouble() - 0.5) * 1.15;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            if (!(level2.random.nextFloat() < 0.35f)) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1225);
        }
    }

    protected void onHit(@NotNull HitResult pResult) {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 120;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SPIN);
        return PlayState.CONTINUE;
    }
}

