/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.trigger.FireRayBeamEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FireRayPieceProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.defineId(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.defineId(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");

    public FireRayPieceProjectile(EntityType<? extends FireRayPieceProjectile> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INDEX, (Object)0);
        builder.define(PARENT_UUID, Optional.empty());
        builder.define(YAW, (Object)Float.valueOf(0.0f));
        builder.define(PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public boolean save(CompoundTag compound) {
        return false;
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        return false;
    }

    @Override
    protected int baseLifetime() {
        return 140;
    }

    public void initAsChild(Entity parent, int index) {
        this.entityData.set(INDEX, (Object)index);
        this.entityData.set(PARENT_UUID, Optional.of(parent.getUUID()));
    }

    public void syncPosition(Vec3 pos) {
        this.setPos(pos.x, pos.y, pos.z);
        Vec3 dir = pos.subtract(this.getOwnerOrigin()).normalize();
        float yaw = (float)(Mth.atan2((double)dir.z, (double)dir.x) * 57.2957763671875) - 90.0f;
        float pitch = (float)(-Mth.atan2((double)dir.y, (double)Math.sqrt(dir.x * dir.x + dir.z * dir.z)) * 57.2957763671875);
        this.entityData.set(YAW, (Object)Float.valueOf(yaw));
        this.entityData.set(PITCH, (Object)Float.valueOf(pitch));
    }

    private Vec3 getOwnerOrigin() {
        Optional ouuid = (Optional)this.entityData.get(PARENT_UUID);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (ouuid.isPresent() && (entity = serverLevel.getEntity((UUID)ouuid.get())) instanceof FireRayBeamEntity) {
                FireRayBeamEntity beam = (FireRayBeamEntity)entity;
                return beam.position();
            }
        }
        return this.position();
    }

    public float getPieceYaw() {
        return ((Float)this.entityData.get(YAW)).floatValue();
    }

    public float getPiecePitch() {
        return ((Float)this.entityData.get(PITCH)).floatValue();
    }

    @Override
    public void tick() {
        List entities;
        super.tick();
        if (!(this.level().isClientSide || this.isInvisible() || (entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.25), e -> !e.equals((Object)this.getOwner()))).isEmpty())) {
            LivingEntity victim = (LivingEntity)entities.get(0);
            victim.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), 5.0f);
            victim.setRemainingFireTicks(this.level().random.nextInt(1, 8) * 20);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.tickCount >= this.baseLifetime() - 6) {
            event.getController().setAnimation(DISAPPEAR);
        } else if (this.tickCount <= 4) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }
}

