/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.FrogHealProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.mixin.CompanionsProjectileAccessor;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrogLevitateProjectile
extends FrogHealProjectile {
    public FrogLevitateProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    public float getDefaultSpeed() {
        return 0.4f;
    }

    @Override
    public float getDefaultLerp() {
        return 0.2f;
    }

    @Override
    protected boolean canHitEntity(@NotNull Entity pTarget) {
        if (Util.areEntitiesLinked((Entity)this, pTarget)) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        Entity entity = this.getOwner();
        return entity == null || ((CompanionsProjectileAccessor)((Object)this)).getLeftOwner() || !entity.isPassengerOfSameVehicle(pTarget);
    }

    @Override
    public void spawnParticles() {
        if (this.tickCount % 8 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        Entity e = pResult.getEntity();
        if (e instanceof LivingEntity) {
            Entity entity;
            LivingEntity entity2 = (LivingEntity)e;
            if (!entity2.hasEffect(MobEffects.LEVITATION)) {
                entity2.addEffect(new MobEffectInstance(MobEffects.LEVITATION, new Random().nextInt(100, 200), 1, true, true, true));
            }
            if (this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                owner.doHurtTarget((Entity)entity2);
            }
        }
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.35f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, e.getX(), e.getY() + (double)e.getBbHeight() * 0.5, e.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.3f)) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), e.getX(), e.getY() + (double)e.getBbHeight() * 0.5, e.getZ(), 1, dx, dy, dz, 0.2);
        }
        this.playSound(SoundEvents.DRAGON_FIREBALL_EXPLODE, 0.5f, 1.0f);
        this.remove(Entity.RemovalReason.KILLED);
    }

    @Override
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.5), this::canHitEntity);
    }
}

