/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class NeedleProjectile
extends HolinessNaginataProjectile
implements GeoEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(NeedleProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public NeedleProjectile(EntityType<? extends ThrownTrident> type, Level level) {
        super(type, level);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        if (!this.level().isClientSide) {
            this.timeToDespawn = new Random().nextInt(80, 160);
        }
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        super.remove(pReason);
        for (int i = 0; i < 8; ++i) {
            double vx = (this.level().random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double vy = (this.level().random.nextDouble() - 0.5) * (double)this.getBbHeight();
            double vz = (this.level().random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 1, vx, vy, vz, 0.15);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getLifetime() >= this.timeToDespawn) {
                this.discard();
            }
            this.setLifetime(this.getLifetime() + 1);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        Entity owner = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        entity.hurt(damageSource, (float)CompanionsConfig.NEEDLE_PROJECTILE_DAMAGE);
        this.playSound(SoundEvents.TRIDENT_HIT, 5.0f, 1.0f);
    }

    @Override
    protected void doShake() {
        if (this.level().isClientSide) {
            for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.02f, 0.02f, 0.02f, 10);
            }
        }
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public void setLifetime(int tick) {
        this.entityData.set(LIFETIME, (Object)tick);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Lifetime", this.getLifetime());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Lifetime")) {
            this.setLifetime(pCompound.getInt("Lifetime"));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFETIME, (Object)80);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoEntity> PlayState predicate(AnimationState<T> state) {
        state.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    @Override
    @NotNull
    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(10.0);
    }
}

