/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoEntity;

public class PontiffFireRingProjectile
extends BaseProjectile
implements GeoEntity {
    public PontiffFireRingProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        double px = this.getX();
        double py = this.getY();
        double pz = this.getZ();
        super.tick();
        this.setPos(px, py, pz);
        if (this.tickCount % 2 == 0 && !this.level().isClientSide) {
            int radius = this.tickCount / 2 + 1;
            double inner = radius - 1;
            double outer = radius + 1;
            AABB box = new AABB(px - outer, py - 1.0, pz - outer, px + outer, py + 1.0, pz + outer);
            for (LivingEntity e2 : this.level().getEntitiesOfClass(LivingEntity.class, box, e -> e.isAlive() && !Util.areEntitiesLinked((Entity)e, this.getOwner()))) {
                double dz;
                double dx = e2.getX() - px;
                double dist = Math.sqrt(dx * dx + (dz = e2.getZ() - pz) * dz);
                if (!(dist > inner) || !(dist <= outer)) continue;
                e2.hurt(this.damageSources().magic(), (float)CompanionsConfig.FIRE_RING_DAMAGE);
                e2.setRemainingFireTicks(this.level().getRandom().nextInt(1, 15) * 20);
            }
        }
    }

    @Override
    protected int baseLifetime() {
        return 20;
    }
}

