/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StakeProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Quaternionf prevRot = new Quaternionf();
    private final Quaternionf currentRot = new Quaternionf();

    public StakeProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = false;
    }

    public StakeProjectile(Level pLevel, LivingEntity pShooter) {
        super(CompanionsEntities.STAKE_PROJECTILE.get(), pShooter, pLevel, ItemStack.EMPTY, null);
        this.noPhysics = false;
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.canHitEntity(entity);
    }

    public void tick() {
        Vec3 velocity = this.getDeltaMovement();
        if (velocity.lengthSqr() > 1.0E-7) {
            this.prevRot.set((Quaternionfc)this.currentRot);
            Vector3f velVec = new Vector3f((float)velocity.x, (float)velocity.y, (float)velocity.z);
            velVec.normalize();
            Vector3f defaultForward = new Vector3f(0.0f, 0.0f, -1.0f);
            float dot = defaultForward.dot((Vector3fc)velVec);
            dot = Math.max(-1.0f, Math.min(1.0f, dot));
            float angle = (float)Math.acos(dot);
            Vector3f axis = defaultForward.cross((Vector3fc)velVec);
            if (axis.length() < 1.0E-4f) {
                axis.set(0.0f, 1.0f, 0.0f);
            } else {
                axis.normalize();
            }
            Quaternionf targetRotation = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, angle);
            this.currentRot.set((Quaternionfc)targetRotation);
        }
        super.tick();
    }

    public Quaternionf getPrevRotation() {
        return this.prevRot;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRot;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }
}

