/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class StoneSpikeProjectile
extends BaseProjectile {
    private final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");

    public StoneSpikeProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount >= this.getLifetime()) {
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount == 5) {
            if (!this.level().isClientSide) {
                this.spawnParticles();
            }
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.STONE_HIT, this.getSoundSource(), 1.0f, 1.0f);
        }
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.3), e -> !e.equals((Object)this.getOwner()));
        for (LivingEntity e2 : entities) {
            if (Util.areEntitiesLinked((Entity)e2, (Entity)this)) continue;
            e2.hurt(this.damageSources().magic(), (float)CompanionsConfig.STONE_SPIKE_DAMAGE);
            Random random = new Random();
            if (!(random.nextFloat() < 0.25f) || e2.hasEffect(MobEffects.POISON)) continue;
            e2.addEffect(new MobEffectInstance(MobEffects.POISON, new Random().nextInt(20, 100), 0, true, true, true));
        }
    }

    private void spawnParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double dx = (sv.getRandom().nextDouble() - 0.5) * 0.1;
                double dy = (sv.getRandom().nextDouble() - 0.5) * 0.1;
                double dz = (sv.getRandom().nextDouble() - 0.5) * 0.1;
                sv.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), this.getX(), this.getY() + 1.0, this.getZ(), 1, dx, dy, dz, 0.0);
            }
        }
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 36;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.APPEAR);
        return PlayState.CONTINUE;
    }
}

