/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TornadoProjectile
extends BaseProjectile {
    private final RawAnimation SPIN = RawAnimation.begin().thenPlay("spin");
    private static final EntityDataAccessor<Float> GROUNDY = SynchedEntityData.defineId(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STARTX = SynchedEntityData.defineId(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STARTZ = SynchedEntityData.defineId(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.defineId(TornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean initialized = false;

    public TornadoProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GROUNDY, (Object)Float.valueOf(0.0f));
        builder.define(STARTX, (Object)Float.valueOf(0.0f));
        builder.define(STARTZ, (Object)Float.valueOf(0.0f));
        builder.define(ALPHA, (Object)Float.valueOf(0.0f));
    }

    public float getGroundY() {
        return ((Float)this.entityData.get(GROUNDY)).floatValue();
    }

    public void setGroundY(float v) {
        this.entityData.set(GROUNDY, (Object)Float.valueOf(v));
    }

    public float getStartX() {
        return ((Float)this.entityData.get(STARTX)).floatValue();
    }

    public void setStartX(float v) {
        this.entityData.set(STARTX, (Object)Float.valueOf(v));
    }

    public float getStartZ() {
        return ((Float)this.entityData.get(STARTZ)).floatValue();
    }

    public void setStartZ(float v) {
        this.entityData.set(STARTZ, (Object)Float.valueOf(v));
    }

    public float getAlpha() {
        return ((Float)this.entityData.get(ALPHA)).floatValue();
    }

    public void setAlpha(float v) {
        this.entityData.set(ALPHA, (Object)Float.valueOf(v));
    }

    @Override
    public void tick() {
        super.tick();
        Entity owner = this.getOwner();
        if (!this.initialized) {
            this.setGroundY((float)this.getY());
            this.setStartX((float)this.getX());
            this.setStartZ((float)this.getZ());
            if (owner != null) {
                Vec3 ownerPos = owner.getEyePosition(1.0f);
                Vec3 projPos = this.position();
                Vec3 dir = projPos.subtract(ownerPos).normalize();
                this.setAlpha((float)Math.atan2(dir.z, dir.x));
            } else {
                this.setAlpha(0.0f);
            }
            this.setNoGravity(true);
            this.initialized = true;
        }
        if (this.tickCount >= this.getLifetime()) {
            this.onExpire();
            return;
        }
        double t = (double)this.tickCount * 0.2;
        double xLocal = Math.sin(0.5 * t) + t;
        double zLocal = Math.cos(0.5 * t);
        double cosA = Math.cos(this.getAlpha());
        double sinA = Math.sin(this.getAlpha());
        this.setPos((double)this.getStartX() + (xLocal * cosA - zLocal * sinA), this.getGroundY(), (double)this.getStartZ() + (xLocal * sinA + zLocal * cosA));
        this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(1.0), e -> !Util.areEntitiesLinked((Entity)this, e)).forEach(e -> {
            Vec3 dir = e.position().subtract(this.position()).normalize().scale(1.4);
            e.push(dir.x + 0.1, dir.y + 0.1, dir.z + 0.1);
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.hurt(this.damageSources().magic(), (float)CompanionsConfig.ICE_TORNADO_DAMAGE);
            }
        });
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            Random random = new Random();
            if ((double)random.nextFloat() <= 0.8) {
                sv.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + (double)(this.getBbWidth() * 2.0f) * Math.random(), this.getY() + (double)(this.getBbHeight() * 2.0f) * Math.random(), this.getZ() + (double)(this.getBbWidth() * 2.0f) * Math.random(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.level().isClientSide && (this.tickCount % 15 == 0 || this.tickCount == 1)) {
            for (int i = 0; i < 3; ++i) {
                float r = (float)(190 + this.level().random.nextInt(30)) / 255.0f;
                float g = (float)(240 + this.level().random.nextInt(10)) / 255.0f;
                float b = (float)(247 + this.level().random.nextInt(5)) / 255.0f;
                Companions.PROXY.spawnBaseProjectileTrail((Entity)this, this.getBbWidth() + this.level().random.nextFloat() * 0.6f, this.getBbHeight() + this.level().random.nextFloat() * 0.5f, r, g, b);
            }
        }
    }

    private void onExpire() {
        if (this.level().isClientSide) {
            this.spawnHitParticles();
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double x = this.getX() + (double)(this.getBbWidth() * 2.0f) * Math.random();
            double y = this.getY() + (double)(this.getBbHeight() * 2.0f) * Math.random();
            double z = this.getZ() + (double)(this.getBbWidth() * 2.0f) * Math.random();
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.05, 0.05, 0.05);
        }
    }

    protected void onHit(@NotNull HitResult pResult) {
        BlockHitResult blockHit;
        Direction hitDirection;
        if (pResult instanceof BlockHitResult && ((hitDirection = (blockHit = (BlockHitResult)pResult).getDirection()) == Direction.UP || hitDirection == Direction.DOWN)) {
            return;
        }
        if (this.level().isClientSide) {
            this.spawnHitParticles();
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.AMETHYST_BLOCK_HIT);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 120;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SPIN);
        return PlayState.CONTINUE;
    }
}

