/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.SummonFrogEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.FireworkToadGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.SummonHopToOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsSummonHurtTargetGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FireworkToadEntity
extends SummonFrogEntity
implements IFrogJumpUtil {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation ROT = RawAnimation.begin().thenPlayAndHold("rot");
    private static final EntityDataAccessor<Vector3f> PARABOLA_CENTER = SynchedEntityData.defineId(FireworkToadEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Boolean> FLY_ENABLED = SynchedEntityData.defineId(FireworkToadEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public FireworkToadEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARABOLA_CENTER, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        builder.define(FLY_ENABLED, (Object)false);
    }

    public void setParabolaCenter(Vec3 center) {
        if (center == null) {
            this.entityData.set(PARABOLA_CENTER, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        } else {
            this.entityData.set(PARABOLA_CENTER, (Object)new Vector3f((float)center.x, (float)center.y, (float)center.z));
        }
    }

    private boolean isFlying() {
        return (Boolean)this.entityData.get(FLY_ENABLED);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLY_ENABLED, (Object)flying);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isFlying() && this.tickCount % 3 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * 0.15, this.getZ(), 0.0, -0.05, 0.0);
        }
    }

    public Vec3 getParabolaCenter() {
        Vector3f v = (Vector3f)this.entityData.get(PARABOLA_CENTER);
        if (v.x() == 0.0f && v.y() == 0.0f && v.z() == 0.0f) {
            return null;
        }
        return new Vec3((double)v.x(), (double)v.y(), (double)v.z());
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FireworkToadGoal(this, 20, 80));
        this.goalSelector.addGoal(4, new SummonHopToOwnerGoal<FireworkToadEntity>(this, 0.725, 6.0f, 2.0f, false));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsSummonHurtTargetGoal(this));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "rot_controller", state -> PlayState.STOP).triggerableAnim("rot", this.ROT));
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.SMALL_FROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.SMALL_FROG_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.SMALL_FROG_IDLE.get();
    }

    @Override
    protected SoundEvent jumpSound() {
        return CompanionsSounds.SMALL_FROG_JUMP.get();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isFlying()) {
            event.setAnimation(this.FLY);
        } else if (this.getCycleCount() >= 0) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void setCanAttack(boolean canAttack) {
    }

    @Override
    public int getAttackType() {
        return 0;
    }
}

