/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.item.TooltipItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CrystallizedBloodItem
extends TooltipItem {
    public CrystallizedBloodItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "crystallized_blood";
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(ctx.getClickedPos());
        if (!(blockEntity instanceof AbstractShadeAltarBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
        if (altar.addCharge() && ctx.getPlayer() != null) {
            if (!ctx.getPlayer().getAbilities().instabuild) {
                ctx.getItemInHand().shrink(1);
            }
            if (!level.isClientSide) {
                ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"crystallized_blood.companions.client_message.added_charge", (Object[])new Object[]{altar.getCharges(), altar.getMaxCharges()}), true);
            }
        } else if (!level.isClientSide && ctx.getPlayer() != null) {
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"crystallized_blood.companions.client_message.max_charges"), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

