/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TooltipArmorItem
extends ArmorItem {
    private String tooltipName = "";

    public TooltipArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public TooltipArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties, String tooltipName) {
        this(armorMaterial, type, properties);
        this.tooltipName = tooltipName;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.tooltipName().isEmpty() && !this.tooltipName().isBlank()) {
            tooltipComponents.add((Component)Component.translatable((String)("tooltip.item.companions." + this.tooltipName())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected String tooltipName() {
        return this.tooltipName;
    }
}

