/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.material;

import dev.xylonity.companions.config.CompanionsConfig;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public enum ItemMaterials implements Tier
{
    NETHERITE_DAGGER("netherite_dagger", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), CompanionsConfig.NETHERITE_DAGGER_STATS),
    CRYSTALLIZED_BLOOD("crystallized_blood", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), CompanionsConfig.CRYSTALLIZED_BLOOD_WEAPON_STATS);

    private final String name;
    private final Supplier<Ingredient> repairIngredient;
    private final String statsCsv;

    private ItemMaterials(String name, Supplier<Ingredient> repairIngredient, String statsCsv) {
        this.name = name;
        this.repairIngredient = repairIngredient;
        this.statsCsv = statsCsv;
    }

    private Stats stats() {
        return new Stats(this.statsCsv);
    }

    public int getUses() {
        return this.stats().durability;
    }

    public float getSpeed() {
        return this.stats().miningSpeed;
    }

    public float getAttackDamageBonus() {
        return this.stats().attackDamage;
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
    }

    public int getEnchantmentValue() {
        return this.stats().enchantability;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public String toString() {
        return this.name;
    }

    private static class Stats {
        final int miningLevel;
        final int durability;
        final float miningSpeed;
        final float attackDamage;
        final int enchantability;

        private Stats(String csv) {
            String[] parts = csv.trim().split("\\s*,\\s*");
            this.miningLevel = Integer.parseInt(parts[0]);
            this.durability = Integer.parseInt(parts[1]);
            this.miningSpeed = Float.parseFloat(parts[2]);
            this.attackDamage = Float.parseFloat(parts[3]);
            this.enchantability = Integer.parseInt(parts[4]);
        }
    }
}

