/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class BlinkParticle
extends TextureSheetParticle {
    private final SpriteSet spritesset;
    private static final float LARGE_SIZE = 8.0f;
    private static final float SMALL_SIZE = 5.0f;

    BlinkParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.lifetime = 5;
        this.setSpriteFromAge(sprites);
        this.spritesset = sprites;
        this.gravity = 0.0f;
        this.quadSize = 8.0f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.quadSize = this.age < 3 ? 8.0f : 5.0f;
        this.setSpriteFromAge(this.spritesset);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType particleType, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new BlinkParticle(level, x, y, z, this.sprites);
        }
    }
}

