/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CakeCreamParticle
extends TextureSheetParticle {
    private final SpriteSet spritesset;
    private boolean hasLanded = false;
    private int landedTicks = 0;
    private static double defaultVelocityX = 0.0;
    private static double defaultVelocityY = 0.0;
    private static double defaultVelocityZ = 0.0;

    public static void setDefaultVelocity(double vx, double vy, double vz) {
        defaultVelocityX = vx;
        defaultVelocityY = vy;
        defaultVelocityZ = vz;
    }

    CakeCreamParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z);
        this.quadSize = new Random().nextFloat(0.15f, 0.4f);
        this.lifetime = new Random().nextInt(50) + 20;
        this.setSpriteFromAge(sprites);
        this.spritesset = sprites;
        this.gravity = 0.15f;
        this.alpha = 0.0f;
        if (velX == 0.0 && velY == 0.0 && velZ == 0.0) {
            this.xd = defaultVelocityX;
            this.yd = defaultVelocityY;
            this.zd = defaultVelocityZ;
        } else {
            this.xd = velX;
            this.yd = velY;
            this.zd = velZ;
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        if (this.hasLanded) {
            ++this.landedTicks;
            if (this.landedTicks >= 40) {
                this.remove();
            }
            return;
        }
        super.tick();
        this.setSpriteFromAge(this.spritesset);
        this.alpha = this.age < 4 ? (float)this.age / 5.0f : 1.0f;
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
    }

    public static Vec3 randomVectorInCone(Vec3 base, double alpha) {
        Vec3 baseNorm = base.normalize();
        Vec3 u = baseNorm.cross(new Vec3(0.0, 1.0, 0.0));
        if (u.lengthSqr() < 1.0E-6) {
            u = baseNorm.cross(new Vec3(1.0, 0.0, 0.0));
        }
        u = u.normalize();
        Vec3 v = baseNorm.cross(u).normalize();
        double minCos = Math.cos(Math.toRadians(alpha));
        double cos = minCos + new Random().nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = new Random().nextDouble() * 2.0 * Math.PI;
        return baseNorm.scale(cos).add(u.scale(sin * Math.cos(phi))).add(v.scale(sin * Math.sin(phi))).scale(base.length());
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
                Vec3 b = new Vec3(defaultVelocityX, defaultVelocityY, defaultVelocityZ);
                Vec3 v = CakeCreamParticle.randomVectorInCone(b, 15.0);
                double f = 0.8 + new Random().nextDouble() * 0.4;
                dx = v.x * f;
                dy = v.y * f;
                dz = v.z * f;
            }
            CakeCreamParticle particle = new CakeCreamParticle(level, x, y, z, this.sprites, dx, dy, dz);
            particle.setPos(x, y, z);
            return particle;
        }
    }
}

