/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class FireworkToadParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final int mode;

    FireworkToadParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z, velX, velY, velZ);
        this.spriteSet = sprites;
        this.quadSize = 0.15f;
        this.lifetime = new Random().nextInt(15) + 20;
        this.gravity = 0.1f;
        this.hasPhysics = true;
        this.friction = 0.98f;
        this.mode = new Random().nextInt(3);
        this.setSpriteFromAge(sprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteSet);
        switch (this.mode) {
            case 0: {
                this.setAlpha(this.age % 4 < 2 ? 1.0f : 0.0f);
                break;
            }
            case 2: {
                this.setAlpha(0.0f);
                if (this.age % 2 != 0) break;
                this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            float speed = 0.5f;
            int size = 1;
            ParticleEngine engine = Minecraft.getInstance().particleEngine;
            Random r = new Random();
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double rx = (double)j + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double ry = (double)i + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double rz = (double)k + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double norm = Math.sqrt(rx * rx + ry * ry + rz * rz) / (double)speed + r.nextGaussian() * 0.05;
                        FireworkToadParticle p = new FireworkToadParticle(level, x, y, z, this.sprites, rx /= norm, ry /= norm, rz /= norm);
                        p.setAlpha(0.99f);
                        engine.add((Particle)p);
                    }
                }
            }
            return null;
        }
    }
}

