/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class SoulFurnaceEntityRecipe
implements Recipe<RecipeInput> {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"soul_furnace_entity_interaction");
    public static final RecipeSerializer<SoulFurnaceEntityRecipe> SERIALIZER = new Serializer();
    public static final RecipeType<SoulFurnaceEntityRecipe> RECIPE_TYPE = new Type();
    public final ItemStack input;
    public final EntityType<?> entityType;

    public SoulFurnaceEntityRecipe(ItemStack input, EntityType<?> entityType) {
        this.input = input;
        this.entityType = entityType;
    }

    public boolean matches(RecipeInput inv, @NotNull Level lvl) {
        return ItemStack.isSameItem((ItemStack)inv.getItem(0), (ItemStack)this.input);
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider reg) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider reg) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return RECIPE_TYPE;
    }

    public static final class Serializer
    implements RecipeSerializer<SoulFurnaceEntityRecipe> {
        private static final MapCodec<SoulFurnaceEntityRecipe> CODEC = MapCodec.unit((Object)new SoulFurnaceEntityRecipe(ItemStack.EMPTY, EntityType.PIG));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceEntityRecipe> STREAM_CODEC = StreamCodec.unit((Object)new SoulFurnaceEntityRecipe(ItemStack.EMPTY, EntityType.PIG));

        @NotNull
        public MapCodec<SoulFurnaceEntityRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceEntityRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static final class Type
    implements RecipeType<SoulFurnaceEntityRecipe> {
        public String toString() {
            return ID.toString();
        }
    }
}

