/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.companions.registry.CompanionsRecipes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulFurnaceRecipe
implements Recipe<RecipeInput> {
    private final Ingredient input;
    private final int requiredCharges;
    private final int processTime;
    @Nullable
    private final Item resultItem;
    private final int resultCount;
    @Nullable
    private final EntityType<?> resultEntity;
    @Nullable
    private final Block resultBlock;

    public SoulFurnaceRecipe(Ingredient input, int requiredCharges, int processTime, @Nullable Item resultItem, int resultCount, @Nullable EntityType<?> resultEntity, @Nullable Block resultBlock) {
        this.input = input;
        this.requiredCharges = requiredCharges;
        this.processTime = processTime;
        this.resultItem = resultItem;
        this.resultCount = resultCount;
        this.resultEntity = resultEntity;
        this.resultBlock = resultBlock;
    }

    public Ingredient input() {
        return this.input;
    }

    public int requiredCharges() {
        return this.requiredCharges;
    }

    public int processTime() {
        return this.processTime;
    }

    @Nullable
    public Item resultItem() {
        return this.resultItem;
    }

    public int resultCount() {
        return this.resultCount;
    }

    @Nullable
    public EntityType<?> resultEntity() {
        return this.resultEntity;
    }

    @Nullable
    public Block resultBlock() {
        return this.resultBlock;
    }

    public boolean outputsItem() {
        return this.resultItem != null;
    }

    public boolean outputsEntity() {
        return this.resultEntity != null;
    }

    public boolean outputsBlock() {
        return this.resultBlock != null;
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return this.input.test(container.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, @NotNull HolderLookup.Provider access) {
        Item item = this.resultItem;
        return item != null ? new ItemStack((ItemLike)item, Math.max(1, this.resultCount)) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider access) {
        Item item = this.resultItem;
        return item != null ? new ItemStack((ItemLike)item, Math.max(1, this.resultCount)) : ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CompanionsRecipes.SOUL_FURNACE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return CompanionsRecipes.SOUL_FURNACE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SoulFurnaceRecipe> {
        private static final MapCodec<SoulFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(SoulFurnaceRecipe::input), (App)Codec.INT.fieldOf("required_charges").orElse((Object)0).forGetter(SoulFurnaceRecipe::requiredCharges), (App)Codec.INT.fieldOf("process_time").orElse((Object)200).forGetter(SoulFurnaceRecipe::processTime), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("result_item").forGetter(r -> Optional.ofNullable(r.resultItem())), (App)Codec.INT.fieldOf("result_count").orElse((Object)1).forGetter(SoulFurnaceRecipe::resultCount), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().optionalFieldOf("result_entity").forGetter(r -> Optional.ofNullable(r.resultEntity())), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("result_block").forGetter(r -> Optional.ofNullable(r.resultBlock()))).apply((Applicative)instance, (in, req, time, itemOpt, cnt, entOpt, blockOpt) -> new SoulFurnaceRecipe((Ingredient)in, (int)req, (int)time, itemOpt.orElse(null), Math.max(1, cnt), entOpt.orElse(null), blockOpt.orElse(null)))).validate(r -> Serializer.exactlyOneResult(r) ? DataResult.success((Object)r) : DataResult.error(() -> "soul_furnace must define exactly one of result_item, result_entity, or result_block"));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceRecipe> STREAM_CODEC = StreamCodec.of((buf, r) -> {
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.input());
            ByteBufCodecs.VAR_INT.encode(buf, (Object)r.requiredCharges());
            ByteBufCodecs.VAR_INT.encode(buf, (Object)r.processTime());
            if (r.resultItem() != null) {
                buf.writeByte((byte)1);
                ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode(buf, (Object)Objects.requireNonNull(r.resultItem()));
                ByteBufCodecs.VAR_INT.encode(buf, (Object)Math.max(1, r.resultCount()));
            } else if (r.resultEntity() != null) {
                buf.writeByte((byte)2);
                ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode(buf, r.resultEntity());
            } else if (r.resultBlock() != null) {
                buf.writeByte((byte)3);
                ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).encode(buf, (Object)r.resultBlock());
            } else {
                buf.writeByte((byte)0);
            }
        }, buf -> {
            Ingredient in = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            int req = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
            int time = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
            byte kind = buf.readByte();
            Item item = null;
            int count = 1;
            EntityType entity = null;
            Block block = null;
            if (kind == 1) {
                item = (Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode(buf);
                count = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
                if (item == Items.AIR) {
                    item = null;
                }
            } else if (kind == 2) {
                entity = (EntityType)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).decode(buf);
            } else if (kind == 3) {
                block = (Block)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).decode(buf);
            }
            return new SoulFurnaceRecipe(in, req, time, item, Math.max(1, count), entity, block);
        });

        private static boolean exactlyOneResult(SoulFurnaceRecipe r) {
            int n = (r.resultItem() != null ? 1 : 0) + (r.resultEntity() != null ? 1 : 0) + (r.resultBlock() != null ? 1 : 0);
            return n == 1;
        }

        @NotNull
        public MapCodec<SoulFurnaceRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

