/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.ShadeMawAltarBlockEntity;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.companion.ShadeMawEntity;
import dev.xylonity.companions.common.recipe.ShadeMawAltarRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class ShadeMawAltarRecipeCategory
implements IRecipeCategory<ShadeMawAltarRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"shade_maw_altar_interaction");
    public static final RecipeType<ShadeMawAltarRecipe> TYPE = new RecipeType(UID, ShadeMawAltarRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/sprites.png");
    private final IDrawable icon;
    private ShadeMawAltarBlockEntity cachedBlockEntity;
    private ShadeMawEntity cachedEntity;
    private long lastUpdateTime = 0L;

    public ShadeMawAltarRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.SHADE_MAW_ALTAR.get()));
    }

    @NotNull
    public RecipeType<ShadeMawAltarRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.companions.shade_maw_altar_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShadeMawAltarRecipe rec, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private ShadeMawAltarBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new ShadeMawAltarBlockEntity(BlockPos.ZERO, CompanionsBlocks.SHADE_MAW_ALTAR.get().defaultBlockState());
            this.cachedBlockEntity.addCharge();
        }
        return this.cachedBlockEntity;
    }

    private ShadeMawEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = new ShadeMawEntity((EntityType<? extends CompanionEntity>)CompanionsEntities.SHADE_MAW.get(), (Level)Minecraft.getInstance().level);
            this.cachedEntity.setIsSpawning(false);
            this.cachedEntity.setNoAi(true);
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        if (this.cachedEntity != null) {
            this.cachedEntity.tickCount = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull ShadeMawAltarRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 10, 55, 0, 0, 39, 17);
        guiGraphics.blit(SHADOW, 32, 10, 56, 30, 24, 22);
        guiGraphics.blit(SHADOW, 70, 45, 142, 6, 24, 12);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        guiGraphics.blit(SHADOW, 97, 50, 170, 0, 42, 25);
        this.updateAnimation();
        ShadeMawAltarBlockEntity be = this.getOrCreateBlockEntity();
        ShadeMawEntity maw = this.getOrCreateEntity();
        GeoBlockRenderer renderer = (GeoBlockRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)be);
        GeoEntityRenderer mawRenderer = (GeoEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)maw);
        if (renderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        pose.pushPose();
        pose.translate(49.0f, 55.0f, 0.0f);
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(45.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.last().normal();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            renderer.render((BlockEntity)be, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        catch (Exception e) {
            renderer.render((BlockEntity)be, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        pose.pushPose();
        pose.translate(130.0f, 65.0f, 20.0f);
        pose.scale(12.0f, 12.0f, 12.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(45.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat2 = pose.last().normal();
        Vector3f up2 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f front2 = new Vector3f(0.0f, 1.0f, 0.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            mawRenderer.render((Entity)maw, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
        }
        catch (Exception e) {
            mawRenderer.render((Entity)maw, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
        }
        pose.popPose();
        buffer.endBatch();
    }
}

