/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CompanionsAddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<CompanionsAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> CompanionsAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, CompanionsAddItemModifier::new)));
    private final Item item;
    private final float chance;

    public CompanionsAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        if (context.getRandom().nextFloat() <= this.chance) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

