/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.platform;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.block.CoinBlock;
import dev.xylonity.companions.common.block.CroissantEggBlock;
import dev.xylonity.companions.common.block.EmptyPuppetBlock;
import dev.xylonity.companions.common.block.EternalFireBlock;
import dev.xylonity.companions.common.block.FrogBonanzaBlock;
import dev.xylonity.companions.common.block.PlasmaLampBlock;
import dev.xylonity.companions.common.block.RecallPlatformBlock;
import dev.xylonity.companions.common.block.RespawnTotemBlock;
import dev.xylonity.companions.common.block.ShadeMawAltarBlock;
import dev.xylonity.companions.common.block.ShadeSwordAltarBlock;
import dev.xylonity.companions.common.block.SoulFurnaceBlock;
import dev.xylonity.companions.common.block.TeslaCoilBlock;
import dev.xylonity.companions.common.block.VoltaicPillarBlock;
import dev.xylonity.companions.common.block.VoltaicRelayBlock;
import dev.xylonity.companions.common.item.CrystallizedBloodItem;
import dev.xylonity.companions.common.item.HourglassItem;
import dev.xylonity.companions.common.item.NeedleItem;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.common.item.WrenchItem;
import dev.xylonity.companions.common.item.armor.BloodArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoBloodArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoHolyRobeArmorItem;
import dev.xylonity.companions.common.item.armor.GeckoMageArmorItem;
import dev.xylonity.companions.common.item.blockitem.CoinItem;
import dev.xylonity.companions.common.item.blockitem.GenericBlockItem;
import dev.xylonity.companions.common.item.book.books.BlackHoleBook;
import dev.xylonity.companions.common.item.book.books.BraceBook;
import dev.xylonity.companions.common.item.book.books.FireMarkBook;
import dev.xylonity.companions.common.item.book.books.HealRingBook;
import dev.xylonity.companions.common.item.book.books.IceShardBook;
import dev.xylonity.companions.common.item.book.books.IceTornadoBook;
import dev.xylonity.companions.common.item.book.books.MagicRayBook;
import dev.xylonity.companions.common.item.book.books.NaginataBook;
import dev.xylonity.companions.common.item.book.books.StoneSpikesBook;
import dev.xylonity.companions.common.item.generic.GenericGeckoItem;
import dev.xylonity.companions.common.item.weapon.BloodAxeItem;
import dev.xylonity.companions.common.item.weapon.BloodScytheItem;
import dev.xylonity.companions.common.item.weapon.BloodSwordItem;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.platform.CompanionsPlatform;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CompanionsNeoForgePlatform
implements CompanionsPlatform {
    @Override
    public <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return Companions.ITEMS.register(id, item);
    }

    @Override
    public <T extends Item> Supplier<T> registerSpecificItem(String id, Item.Properties properties, CompanionsItems.ItemType itemType) {
        switch (itemType) {
            case HOURGLASS: {
                return this.registerItem(id, () -> new HourglassItem(properties));
            }
            case WRENCH: {
                return this.registerItem(id, () -> new WrenchItem(properties));
            }
            case CRYSTALLIZED_BLOOD: {
                return this.registerItem(id, () -> new CrystallizedBloodItem(properties));
            }
            case NEEDLE: {
                return this.registerItem(id, () -> new NeedleItem(properties));
            }
            case GENERIC: {
                return this.registerItem(id, () -> new GenericGeckoItem(properties, id));
            }
        }
        return this.registerItem(id, () -> new ShadowBellItem(properties));
    }

    @Override
    public <T extends Item> Supplier<T> registerMusicDisc(String id, int signal, Supplier<SoundEvent> soundEvent, Item.Properties properties, int length) {
        return this.registerItem(id, () -> new Item(properties.jukeboxPlayable(ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"saint_klimt")))));
    }

    @Override
    public <T extends Item> Supplier<T> registerSpecificItem(String id, Item.Properties properties, CompanionsItems.ItemType itemType, ItemMaterials material, float extraDamage, float extraSpeed) {
        switch (itemType) {
            case BLOOD_SWORD: {
                return this.registerItem(id, () -> new BloodSwordItem(properties.fireResistant().attributes(SwordItem.createAttributes((Tier)material, (float)this.extra(8, extraDamage), (float)this.extra(11, extraSpeed))), id, material));
            }
            case BLOOD_AXE: {
                return this.registerItem(id, () -> new BloodAxeItem(properties.fireResistant().attributes(AxeItem.createAttributes((Tier)material, (float)this.extra(6, extraDamage), (float)this.extra(9, extraSpeed))), id, material));
            }
            case BLOOD_PICKAXE: {
                return this.registerItem(id, () -> new BloodScytheItem(properties.fireResistant().attributes(PickaxeItem.createAttributes((Tier)material, (float)this.extra(7, extraDamage), (float)this.extra(10, extraSpeed))), id, material));
            }
        }
        return this.registerSpecificItem(id, properties, itemType);
    }

    private float extra(int idx, float fallback) {
        String[] parts = CompanionsConfig.CRYSTALLIZED_BLOOD_WEAPON_STATS.trim().split("\\s*,\\s*");
        float ret = fallback;
        if (parts.length >= idx) {
            ret = Float.parseFloat(parts[idx - 1]);
        }
        return ret;
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String id, BlockBehaviour.Properties properties, CompanionsBlocks.BlockType blockType, CompanionsBlocks.BlockItem blockItem) {
        DeferredHolder tr = switch (blockType) {
            case CompanionsBlocks.BlockType.COIN_BLOCK -> Companions.BLOCKS.register(id, () -> new CoinBlock(properties));
            case CompanionsBlocks.BlockType.SOUL_FURNACE -> Companions.BLOCKS.register(id, () -> new SoulFurnaceBlock(properties.lightLevel(v -> (Boolean)v.getValue((Property)SoulFurnaceBlock.LIT) != false ? 13 : 0)));
            case CompanionsBlocks.BlockType.CROISSANT_EGG -> Companions.BLOCKS.register(id, () -> new CroissantEggBlock(properties));
            case CompanionsBlocks.BlockType.PLASMA_LAMP -> Companions.BLOCKS.register(id, () -> new PlasmaLampBlock(properties.lightLevel(v -> (Boolean)v.getValue((Property)PlasmaLampBlock.LIT) != false ? 15 : 0)));
            case CompanionsBlocks.BlockType.VOLTAIC_PILLAR -> Companions.BLOCKS.register(id, () -> new VoltaicPillarBlock(properties));
            case CompanionsBlocks.BlockType.EMPTY_PUPPET -> Companions.BLOCKS.register(id, () -> new EmptyPuppetBlock(properties));
            case CompanionsBlocks.BlockType.RESPAWN_TOTEM -> Companions.BLOCKS.register(id, () -> new RespawnTotemBlock(properties.lightLevel(v -> (Boolean)v.getValue((Property)RespawnTotemBlock.LIT) != false ? 13 : 0)));
            case CompanionsBlocks.BlockType.SHADE_SWORD_ALTAR -> Companions.BLOCKS.register(id, () -> new ShadeSwordAltarBlock(properties));
            case CompanionsBlocks.BlockType.SHADE_MAW_ALTAR -> Companions.BLOCKS.register(id, () -> new ShadeMawAltarBlock(properties));
            case CompanionsBlocks.BlockType.RECALL_PLATFORM -> Companions.BLOCKS.register(id, () -> new RecallPlatformBlock(properties));
            case CompanionsBlocks.BlockType.VOLTAIC_RELAY -> Companions.BLOCKS.register(id, () -> new VoltaicRelayBlock(properties));
            case CompanionsBlocks.BlockType.FROG_BONANZA -> Companions.BLOCKS.register(id, () -> new FrogBonanzaBlock(properties));
            case CompanionsBlocks.BlockType.ETERNAL_FIRE -> Companions.BLOCKS.register(id, () -> new EternalFireBlock(properties));
            default -> Companions.BLOCKS.register(id, () -> new TeslaCoilBlock(properties));
        };
        Supplier<Item> item = switch (blockItem) {
            case CompanionsBlocks.BlockItem.COIN -> () -> CompanionsNeoForgePlatform.lambda$registerBlock$27((Supplier)tr, id);
            default -> () -> CompanionsNeoForgePlatform.lambda$registerBlock$28((Supplier)tr, id);
        };
        this.registerItem(id, item);
        return tr;
    }

    @Override
    public <T extends Item> Supplier<T> registerArmorItem(String id, Holder<ArmorMaterial> armorMaterial, ArmorItem.Type armorType, boolean isGeckoArmor) {
        if (isGeckoArmor) {
            if (armorMaterial == ArmorMaterials.CRYSTALLIZED_BLOOD) {
                return this.registerItem(id, () -> new GeckoBloodArmorItem(armorMaterial, armorType, new Item.Properties().fireResistant().durability(this.getDurabilityMultiplier(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS)), id));
            }
            if (armorMaterial == ArmorMaterials.MAGE) {
                return this.registerItem(id, () -> new GeckoMageArmorItem(armorMaterial, armorType, new Item.Properties().durability(this.getDurabilityMultiplier(CompanionsConfig.MAGE_SET_STATS)), id));
            }
            return this.registerItem(id, () -> new GeckoHolyRobeArmorItem(armorMaterial, armorType, new Item.Properties().fireResistant().durability(this.getDurabilityMultiplier(CompanionsConfig.HOLY_ROBE_SET_STATS)), id));
        }
        if (armorMaterial == ArmorMaterials.CRYSTALLIZED_BLOOD) {
            return this.registerItem(id, () -> new BloodArmorItem(armorMaterial, armorType, new Item.Properties().fireResistant().durability(this.getDurabilityMultiplier(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS))));
        }
        return this.registerItem(id, () -> new ArmorItem(armorMaterial, armorType, new Item.Properties().durability(35)));
    }

    private int getDurabilityMultiplier(String configEntry) {
        String[] parts = configEntry.trim().split("\\s*,\\s*");
        return Integer.parseInt(parts[6]);
    }

    @Override
    public <T extends Item> Supplier<T> registerMagicBook(String id, Item.Properties properties, CompanionsItems.MagicType magicType) {
        switch (magicType) {
            case ICE_TORNADO: {
                return this.registerItem(id, () -> new IceTornadoBook(properties));
            }
            case FIRE_MARK: {
                return this.registerItem(id, () -> new FireMarkBook(properties));
            }
            case STONE_SPIKES: {
                return this.registerItem(id, () -> new StoneSpikesBook(properties));
            }
            case HEAL_RING: {
                return this.registerItem(id, () -> new HealRingBook(properties));
            }
            case BRACE: {
                return this.registerItem(id, () -> new BraceBook(properties));
            }
            case MAGIC_RAY: {
                return this.registerItem(id, () -> new MagicRayBook(properties));
            }
            case BLACK_HOLE: {
                return this.registerItem(id, () -> new BlackHoleBook(properties));
            }
            case NAGINATA: {
                return this.registerItem(id, () -> new NaginataBook(properties));
            }
        }
        return this.registerItem(id, () -> new IceShardBook(properties));
    }

    @Override
    public <T extends MobEffect> Holder<T> registerEffect(String id, Supplier<T> effect) {
        return Companions.MOB_EFFECTS.register(id, effect).getDelegate();
    }

    @Override
    public <T extends ParticleType<?>> Supplier<T> registerParticle(String id, boolean overrideLimiter) {
        return Companions.PARTICLES.register(id, () -> new SimpleParticleType(overrideLimiter));
    }

    @Override
    public <T extends SoundEvent> Supplier<T> registerSound(String id, Supplier<T> sound) {
        return Companions.SOUNDS.register(id, sound);
    }

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String id, Supplier<T> tab) {
        return Companions.CREATIVE_TABS.register(id, tab);
    }

    @Override
    public <T extends ArmorMaterial> Holder<T> registerArmorMaterial(String id, Supplier<T> armorMaterial) {
        return Companions.ARMOR_MATERIALS.register(id, armorMaterial);
    }

    @Override
    public CreativeModeTab.Builder creativeTabBuilder() {
        return CreativeModeTab.builder();
    }

    @Override
    public <T extends Raider> EntityType<T> getIllagerGolemEntity() {
        return CompanionsEntities.ILLAGER_GOLEM.get();
    }

    @Override
    public <T extends Entity> EntityType<T> getFireMarkProjectile() {
        return CompanionsEntities.FIRE_MARK_PROJECTILE.get();
    }

    private static /* synthetic */ Item lambda$registerBlock$28(Supplier tr, String id) {
        return new GenericBlockItem((Block)tr.get(), new Item.Properties(), id);
    }

    private static /* synthetic */ Item lambda$registerBlock$27(Supplier tr, String id) {
        return new CoinItem((Block)tr.get(), new Item.Properties(), id);
    }
}

