/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.blockentity.FrogBonanzaBlockEntity;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrogBonanzaBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_LOWER_N = Stream.of(Block.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)14.0, (double)17.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)-0.5, (double)16.0, (double)3.0, (double)16.5, (double)26.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_UPPER_N = Stream.of(Block.m_49796_((double)2.0, (double)-12.0, (double)4.0, (double)14.0, (double)1.0, (double)12.0), Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.m_49796_((double)-0.5, (double)0.0, (double)3.0, (double)16.5, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_UPPER_E = Stream.of(Block.m_49796_((double)4.0, (double)-12.0, (double)2.0, (double)12.0, (double)1.0, (double)14.0), Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)-0.5, (double)13.0, (double)10.0, (double)16.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_LOWER_E = Stream.of(Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)17.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)3.0, (double)16.0, (double)-0.5, (double)13.0, (double)26.0, (double)16.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public FrogBonanzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public long m_7799_(@NotNull BlockState pState, @NotNull BlockPos pPos) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos.m_121878_() : pPos.m_7495_().m_121878_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction d = (Direction)pState.m_61143_((Property)FACING);
        if (d == Direction.NORTH || d == Direction.SOUTH) {
            return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_N : SHAPE_UPPER_N;
        }
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_E : SHAPE_UPPER_E;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return pPos.m_123342_() < pLevel.m_151558_() - 1;
        }
        BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
        return belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && pDirection == Direction.UP) {
                return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pState : Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.UPPER && pDirection == Direction.DOWN) {
                return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pState : Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.f_46443_) {
            if (pPlayer.m_7500_()) {
                FrogBonanzaBlock.preventCreativeTabDestroy(pLevel, pPos, pState, pPlayer);
            } else {
                BlockPos oPos = pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos.m_7494_() : pPos.m_7495_();
                BlockState oState = pLevel.m_8055_(oPos);
                if (oState.m_60713_((Block)this)) {
                    pLevel.m_7731_(oPos, Blocks.f_50016_.m_49966_(), 35);
                    pLevel.m_5898_(pPlayer, 2001, oPos, Block.m_49956_((BlockState)oState));
                }
                FrogBonanzaBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public static void preventCreativeTabDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER && (lowerState = pLevel.m_8055_(lowerPos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = this.getMultiblockBlockEntity(pLevel, pPos, pState);
        if (blockEntity instanceof FrogBonanzaBlockEntity) {
            FrogBonanzaBlockEntity bonanza = (FrogBonanzaBlockEntity)blockEntity;
            return bonanza.interact(pPlayer, pHand);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT, HALF});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? ((BlockEntityType)CompanionsBlockEntities.FROG_BONANZA.get()).m_155264_(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER && pBlockEntityType == CompanionsBlockEntities.FROG_BONANZA.get() ? FrogBonanzaBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity getMultiblockBlockEntity(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return level.m_7702_(pos);
        }
        BlockPos lowerPos = pos.m_7495_();
        BlockState lowerState = level.m_8055_(lowerPos);
        if (lowerState.m_60713_((Block)this) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return level.m_7702_(lowerPos);
        }
        return null;
    }
}

