/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.croissant;

import dev.xylonity.companions.common.entity.companion.CroissantDragonEntity;
import dev.xylonity.companions.common.entity.projectile.trigger.CakeCreamTriggerProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CroissantDragonAttackGoal
extends Goal {
    private final CroissantDragonEntity dragon;
    private int tickCount;
    private int cooldown = 0;
    private int attacksOnSameTarget = 0;
    private LivingEntity lastTarget;

    public CroissantDragonAttackGoal(CroissantDragonEntity dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        LivingEntity target = this.dragon.m_5448_();
        return target != null && target.m_6084_();
    }

    public boolean m_8045_() {
        return this.tickCount < 25 && this.dragon.m_5448_() != null && this.dragon.m_5448_().m_6084_();
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.dragon.setAttacking(true);
        TickScheduler.scheduleServer((Level)this.dragon.m_9236_(), () -> this.dragon.setAttacking(false), (int)50);
        LivingEntity currentTarget = this.dragon.m_5448_();
        if (!(currentTarget == null || this.lastTarget != null && this.lastTarget.equals((Object)currentTarget))) {
            this.lastTarget = currentTarget;
            this.attacksOnSameTarget = 0;
        }
    }

    public void m_8037_() {
        ++this.tickCount;
        LivingEntity target = this.dragon.m_5448_();
        if (target != null) {
            this.dragon.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double dx = target.m_20185_() - this.dragon.m_20185_();
            double dz = target.m_20189_() - this.dragon.m_20189_();
            float angle = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            this.dragon.m_146922_(angle);
            this.dragon.f_20883_ = angle;
            this.dragon.f_20885_ = angle;
            this.dragon.f_19859_ = angle;
            this.dragon.f_20884_ = angle;
            this.dragon.f_20886_ = angle;
        }
        if (this.tickCount >= 5) {
            if (this.tickCount == 5) {
                this.dragon.m_5496_(CompanionsSounds.CROISSANT_DRAGON_BREATH.get(), 1.5f, 1.0f);
            }
            Vec3 eyePos = new Vec3(this.dragon.m_20185_(), this.dragon.m_20186_() + (double)this.dragon.m_20192_() * 0.2, this.dragon.m_20189_());
            Vec3 viewVector = this.dragon.m_20252_(1.0f).m_82541_();
            Vec3 spawnPos = eyePos.m_82549_(viewVector.m_82490_(1.0));
            this.dragon.setStoredViewVector(viewVector);
            Level angle = this.dragon.m_9236_();
            if (angle instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)angle;
                SimpleParticleType particle = this.dragon.getArmorName().equals("chocolate") ? CompanionsParticles.CAKE_CREAM_CHOCOLATE.get() : (this.dragon.getArmorName().equals("strawberry") ? CompanionsParticles.CAKE_CREAM_STRAWBERRY.get() : CompanionsParticles.CAKE_CREAM.get());
                level.m_8767_((ParticleOptions)particle, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 12, 0.0, 0.0, 0.0, 0.0);
            }
            if (!this.dragon.m_9236_().m_5776_() && this.tickCount % 2 == 0) {
                CakeCreamTriggerProjectile projectile = new CakeCreamTriggerProjectile((EntityType<? extends Projectile>)((EntityType)CompanionsEntities.CAKE_CREAM_TRIGGER_PROJECTILE.get()), this.dragon.m_9236_());
                projectile.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_ + new Random().nextDouble(0.0, 1.0), spawnPos.f_82481_);
                projectile.setArmorName(this.dragon.getArmorName());
                projectile.m_5602_((Entity)this.dragon);
                projectile.m_20256_(Util.randomVectorInCone(viewVector, 15.0, new Random()).m_82490_(0.5 * (0.8 + new Random().nextDouble() * 0.4)));
                this.dragon.m_9236_().m_7967_((Entity)projectile);
            }
        }
    }

    public void m_8041_() {
        LivingEntity currentTarget = this.dragon.m_5448_();
        if (currentTarget != null) {
            if (this.lastTarget != null && this.lastTarget.equals((Object)currentTarget)) {
                ++this.attacksOnSameTarget;
            } else {
                this.lastTarget = currentTarget;
                this.attacksOnSameTarget = 1;
            }
            if (this.attacksOnSameTarget >= 3) {
                this.dragon.m_6710_(null);
                this.attacksOnSameTarget = 0;
            }
        } else {
            this.attacksOnSameTarget = 0;
            this.lastTarget = null;
        }
        this.cooldown = this.dragon.m_217043_().m_188503_(61) + 60;
    }
}

