/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.FireGeiserProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HolinessImpactAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public HolinessImpactAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 64, minCd, maxCd);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.pontiff.setNoMovement(true);
        this.pontiff.setShouldLookAtTarget(false);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.pontiff.setNoMovement(false);
        this.pontiff.setShouldLookAtTarget(true);
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e2 : target.m_9236_().m_6443_(LivingEntity.class, new AABB(this.pontiff.m_20183_()).m_82400_(2.0), e -> !(e instanceof HostileEntity))) {
            this.pontiff.m_7327_((Entity)e2);
            e2.m_147240_(1.0, this.pontiff.m_20185_() - target.m_20185_(), this.pontiff.m_20189_() - target.m_20189_());
        }
        Level level = this.pontiff.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.doEarthquake(serverLevel, this.pontiff.m_20183_().m_121945_(this.pontiff.m_6350_()));
        }
    }

    private void doEarthquake(ServerLevel serverLevel, BlockPos center) {
        ArrayList<BlockPos> plate;
        int radius = 10;
        boolean[][] claimedPortions = new boolean[radius * 2 + 1][radius * 2 + 1];
        ArrayList plates = new ArrayList();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int cj;
                int ci;
                if ((double)this.pontiff.m_217043_().m_188501_() > 0.2 || claimedPortions[ci = dx + radius][cj = dz + radius]) continue;
                int size = 3 + this.pontiff.m_217043_().m_188503_(2);
                plate = new ArrayList<BlockPos>(size * size);
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        int jj;
                        int ii;
                        int rx = dx + x;
                        int rz = dz + z;
                        if (Math.abs(rx) > radius || Math.abs(rz) > radius || claimedPortions[ii = rx + radius][jj = rz + radius]) continue;
                        claimedPortions[ii][jj] = true;
                        plate.add(center.m_7918_(rx, -1, rz));
                    }
                }
                if (plate.isEmpty()) continue;
                plates.add(plate);
            }
        }
        int tickDelay = 0;
        int plateCount = 0;
        for (int i = 0; i < plates.size(); ++i) {
            if (plateCount == 4) {
                tickDelay += 3;
                plateCount = 0;
            }
            double yDelay = 0.18 + 0.005 * (double)i;
            plate = (ArrayList<BlockPos>)plates.get(i);
            Runnable task = () -> {
                for (BlockPos bp : plate) {
                    BlockState state = serverLevel.m_8055_(bp);
                    if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_) continue;
                    this.spawnFallingBlock(serverLevel, bp, state, yDelay);
                }
                BlockPos randPos = (BlockPos)plate.get(this.pontiff.m_217043_().m_188503_(plate.size()));
                double x = (double)randPos.m_123341_() + this.pontiff.m_217043_().m_188500_();
                double z = (double)randPos.m_123343_() + this.pontiff.m_217043_().m_188500_();
                FireGeiserProjectile geiser = (FireGeiserProjectile)((EntityType)CompanionsEntities.FIRE_GEISER_PROJECTILE.get()).m_20615_((Level)serverLevel);
                if (geiser != null && serverLevel.f_46441_.m_188501_() < 0.35f) {
                    geiser.m_7678_(x, (double)randPos.m_123342_() + 0.75, z, 0.0f, 0.0f);
                    geiser.m_5602_((Entity)this.pontiff);
                    serverLevel.m_7967_((Entity)geiser);
                }
                if (this.pontiff.m_217043_().m_188501_() < 0.65f) {
                    for (int j = 0; j < 10; ++j) {
                        double dx = (this.pontiff.m_217043_().m_188500_() - 0.5) * 2.0;
                        double dy = (this.pontiff.m_217043_().m_188500_() - 0.5) * 2.0;
                        double dz = (this.pontiff.m_217043_().m_188500_() - 0.5) * 2.0;
                        Level patt5127$temp = this.pontiff.m_9236_();
                        if (!(patt5127$temp instanceof ServerLevel)) continue;
                        ServerLevel level = (ServerLevel)patt5127$temp;
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, (double)(randPos.m_123342_() + 1), z, 1, dx, dy, dz, 0.2);
                    }
                }
            };
            if (tickDelay == 0) {
                task.run();
            } else {
                TickScheduler.scheduleServer((Level)serverLevel, (Runnable)task, (int)tickDelay);
            }
            ++plateCount;
        }
    }

    private void spawnFallingBlock(ServerLevel level, BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity fallingBlock = new FallingBlockEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, state);
        fallingBlock.m_20334_(0.0, yDelay, 0.0);
        level.m_7967_((Entity)fallingBlock);
        level.m_7471_(pos, false);
    }

    @Override
    protected int attackDelay() {
        return 35;
    }

    @Override
    protected int attackState() {
        return 6;
    }
}

