/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.summon.BubbleFrogEntity;
import dev.xylonity.companions.common.entity.summon.EmberPoleEntity;
import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import dev.xylonity.companions.common.entity.summon.FireworkToadEntity;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScrollProjectile
extends BaseProjectile {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private static final EntityDataAccessor<Integer> ENTITY_TO_SPAWN = SynchedEntityData.m_135353_(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> SECOND_OWNER_UUID = SynchedEntityData.m_135353_(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final int WHEN_TO_SUMMON = 30;

    public ScrollProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 30 && !this.m_9236_().f_46443_) {
            this.spawnParticles();
            CompanionSummonEntity e = this.getEntityToSpawn();
            if (e != null && this.getOwnerUUID() != null) {
                e.m_21816_(this.getOwnerUUID());
                e.setSecondOwnerUUID(this.getSecondOwnerUUID());
                e.m_7105_(true);
                e.m_20219_(this.m_20182_());
                this.m_9236_().m_7967_((Entity)e);
            }
            this.m_5496_(CompanionsSounds.SCROLL_SOUND.get(), 0.75f, 1.0f);
        }
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public UUID getSecondOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SECOND_OWNER_UUID)).orElse(null);
    }

    public void setSecondOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SECOND_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    private CompanionSummonEntity getEntityToSpawn() {
        return switch ((Integer)this.f_19804_.m_135370_(ENTITY_TO_SPAWN)) {
            case 1 -> (FireworkToadEntity)((EntityType)CompanionsEntities.FIREWORK_TOAD.get()).m_20615_(this.m_9236_());
            case 2 -> (NetherBullfrogEntity)((EntityType)CompanionsEntities.NETHER_BULLFROG.get()).m_20615_(this.m_9236_());
            case 3 -> (EnderFrogEntity)((EntityType)CompanionsEntities.ENDER_FROG.get()).m_20615_(this.m_9236_());
            case 4 -> (EmberPoleEntity)((EntityType)CompanionsEntities.EMBER_POLE.get()).m_20615_(this.m_9236_());
            case 5 -> (BubbleFrogEntity)((EntityType)CompanionsEntities.BUBBLE_FROG.get()).m_20615_(this.m_9236_());
            default -> null;
        };
    }

    private void spawnParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            double dy = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            double dz = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.75;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)this.m_20206_(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENTITY_TO_SPAWN, (Object)0);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(SECOND_OWNER_UUID, Optional.empty());
    }

    public void setEntityToSpawn(int id) {
        this.f_19804_.m_135381_(ENTITY_TO_SPAWN, (Object)id);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.SPAWN);
        return PlayState.CONTINUE;
    }

    @Override
    protected int baseLifetime() {
        return 47;
    }
}

